/*
 * 
 *  Copyright (C) 2011 Mateusz Kopec
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 */
package annotation;

import java.util.Collection;

import basic.Context;
import corpusapi.Sense;

/**
 * MFS word expert
 * 
 * @author Mateusz Kopec
 * 
 */
public class WEMFS extends WordExpert {

	private Sense answer;

	/**
	 * Constructor
	 * 
	 * @param baseForm
	 *            base form of the word
	 * @param senses
	 *            senses of this word
	 * @param answerId
	 *            most freqent sense id
	 */
	public WEMFS(String baseForm, Collection<? extends Sense> senses, String answerId) {
		super(baseForm, senses);
		for (Sense s : senses) {
			if (s.getId().equals(answerId)) {
				answer = s;
				break;
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see annotation.WordExpert#disambiguate(basic.Context)
	 */
	@Override
	public Sense disambiguate(Context context) {
		return answer;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see annotation.WordExpert#getParamString()
	 */
	@Override
	public String getParamString() {
		return "MFS";
	}
}
