/*
 * 
 *  Copyright (C) 2011 Mateusz Kopec
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 */
package utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

/**
 * Helper class for managing the files
 * 
 * @author Mateusz Kopec
 * 
 */
public class FileManager {
	/**
	 * Saves java object at given path
	 * 
	 * @param o
	 *            object
	 * @param path
	 */
	public static void saveObject(Object o, String path) {
		System.out.println("Saving object at path: " + path);
		FileOutputStream fos = null;
		ObjectOutputStream out = null;
		try {
			fos = new FileOutputStream(path);
			out = new ObjectOutputStream(fos);
			out.writeObject(o);
			out.close();
			fos.close();
		} catch (IOException ex) {
			ex.printStackTrace();
			System.exit(1);
		}
	}

	/**
	 * Loads object from file
	 * 
	 * @param path
	 *            to the file
	 * @return object
	 */
	public static Object loadObject(String path) {
		FileInputStream fis = null;
		ObjectInputStream in = null;
		try {
			fis = new FileInputStream(path);
			in = new ObjectInputStream(fis);
			Object object = in.readObject();
			in.close();
			fis.close();
			System.out.println("Object loaded sucessfully at path: " + path);
			in = null;
			fis = null;
			return object;
		} catch (IOException ex) {
			System.out.println("Object load error.");
		} catch (ClassNotFoundException ex) {
			System.out.println("Object load error.");
		}
		return null;
	}

	/**
	 * Saves string to a file
	 * 
	 * @param string
	 *            string to save
	 * @param where
	 *            path to the file
	 */
	public static void saveStringInFile(String string, String where) {
		try {
			File g = new File(where);
			BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(g), "UTF8"));
			out.write(string);
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	/**
	 * Saves list of strings in a file (in new line each)
	 * 
	 * @param l
	 *            list
	 * @param where
	 *            path to the file
	 */
	public static void saveStringListInFile(List<String> l, String where) {
		try {
			File g = new File(where);
			BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(g), "UTF8"));
			for (String s : l)
				out.write(s + "\n");
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	/**
	 * Copies directory recursively. If targetLocation does not exist, it will
	 * be created.
	 * 
	 * @param sourceLocation
	 *            from
	 * @param targetLocation
	 *            to
	 * @throws IOException
	 */
	public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {

		if (sourceLocation.isDirectory()) {
			if (!targetLocation.exists()) {
				if (!targetLocation.mkdirs())
					throw new IOException("Error creating target dir!");
			}

			String[] children = sourceLocation.list();
			for (int i = 0; i < children.length; i++) {
				copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
			}
		} else {
			InputStream in = new FileInputStream(sourceLocation);
			OutputStream out = new FileOutputStream(targetLocation);

			// Copy the bits from instream to outstream
			byte[] buf = new byte[1024];
			int len;
			while ((len = in.read(buf)) > 0) {
				out.write(buf, 0, len);
			}
			in.close();
			out.close();
		}
	}

}
