/*
 * 
 *  Copyright (C) 2011 Mateusz Kopec
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 */
package utils;

import java.util.Collection;
import java.util.Iterator;

/**
 * Various utilities
 * 
 * @author Mateusz Kopec
 * 
 */
public class Utils {
	/**
	 * Regular expression of single word
	 */
	public final static String singleWordRegex = "[a-zA-ZąĄćĆęĘłŁńŃóÓśŚźŹżŻ\\-é]+";
	/**
	 * Regular expression of a whitespace
	 */
	public final static String whitespaceRegex = "[^a-zA-ZąĄćĆęĘłŁńŃóÓśŚźŹżŻ\\-é]+";

	/**
	 * Rounds a number to 3 decimal places
	 * 
	 * @param number
	 *            to round
	 * @return rounded number
	 */
	public static double round(double number) {
		return round(number, 3);
	}

	private static double round(double number, int digits) {
		int factor = (int) Math.pow(10, digits);
		return 1.0 * ((int) (number * factor)) / factor;
	}

	/**
	 * Joins a collection of strings with a delimiter between each two strings
	 * 
	 * @param s
	 *            collection
	 * @param delimiter
	 * @return concatenated string
	 */
	public static String join(Collection<String> s, String delimiter) {
		if (s.isEmpty())
			return "";
		Iterator<String> iter = s.iterator();
		StringBuffer buffer = new StringBuffer(iter.next());
		while (iter.hasNext())
			buffer.append(delimiter).append(iter.next());
		return buffer.toString();
	}

	/**
	 * Fills string with spaces to reach given length
	 * 
	 * @param what
	 *            string
	 * @param totalLength
	 *            length to reach
	 * @return modified string
	 */
	public static String fillWithWhitespace(String what, int totalLength) {
		int lengthNow = what.length();
		StringBuffer sb = new StringBuffer(what);
		for (int i = 0; i + lengthNow < totalLength; i++) {
			sb.append(' ');
		}
		return sb.toString();
	}
}
