/*
 * 
 *  Copyright (C) 2011 Mateusz Kopec
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 */
package annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

import basic.Context;
import corpusapi.Sense;

/**
 * Random word expert
 * 
 * @author Mateusz Kopec
 * 
 */
public class WERandom extends WordExpert {

	private Random r = new Random(1);

	/**
	 * Constructor
	 * 
	 * @param baseForm
	 *            base form of word
	 * @param senses
	 *            word's senses
	 */
	public WERandom(String baseForm, Collection<? extends Sense> senses) {
		super(baseForm, senses);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see annotation.WordExpert#disambiguate(basic.Context)
	 */
	@Override
	public Sense disambiguate(Context context) {
		int senseCount = senses.size();
		List<Sense> list = new ArrayList<Sense>(senses);
		return list.get(r.nextInt(senseCount));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see annotation.WordExpert#getParamString()
	 */
	@Override
	public String getParamString() {
		return "Random";
	}
}
