/*
 * 
 *  Copyright (C) 2011 Mateusz Kopec
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 */
package annotation;

import java.util.Collection;

import basic.Context;
import corpusapi.Sense;

/**
 * Expert which have the knowledge of disambiguation of a chosen word.
 * 
 * @author Mateusz Kopec
 * 
 */
public abstract class WordExpert {
	/** A base form of a word for which the expert is eligible. */
	protected String wordBaseForm;
	/** A list of possible senses for the expert's word of capability. */
	protected Collection<? extends Sense> senses;

	/**
	 * Constructor
	 * 
	 * @param baseForm
	 *            base form of the word
	 * @param senses
	 *            word's senses
	 */
	public WordExpert(String baseForm, Collection<? extends Sense> senses) {
		wordBaseForm = baseForm;
		this.senses = senses;
	}

	/**
	 * Returns chosen sense of the word in context
	 * 
	 * @param context
	 *            context
	 * @return sense chosen by word expert
	 */
	public abstract Sense disambiguate(Context context);

	/**
	 * Returns string representation of the method
	 * 
	 * @return representation
	 */
	public abstract String getParamString();
}
