/*
 * 
 *  Copyright (C) 2011 Mateusz Kopec
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 */

package basic;

/**
 * Represents context, stores list of words and position of keyword.
 * 
 * @author Mateusz Kopec
 */
public class Context extends WordList {

	private int keywordIndex;

	/**
	 * Constructor which copies another context
	 * 
	 * @param context
	 *            context to copy
	 */
	public Context(Context context) {
		super(context);
		this.keywordIndex = context.getKeywordIndex();
	}

	/**
	 * Constructor
	 */
	public Context() {
		super();
	}

	/**
	 * Sets the index of keyword in context
	 * 
	 * @param i
	 */
	public void setKeywordIndex(int i) {
		this.keywordIndex = i;
	}

	/**
	 * Gets the index of keyword in context
	 * 
	 * @return index
	 */
	public int getKeywordIndex() {
		return keywordIndex;
	}

	/**
	 * Narrows the context to chosen window width
	 * 
	 * @param contextWindow
	 *            width
	 */
	public void cutToWindow(int contextWindow) {
		orths = orths.subList(Math.max(keywordIndex - contextWindow, 0), Math.min(keywordIndex + contextWindow + 1,
				orths.size()));

		bases = bases.subList(Math.max(keywordIndex - contextWindow, 0), Math.min(keywordIndex + contextWindow + 1,
				bases.size()));

		if (keywordIndex > contextWindow)
			setKeywordIndex(contextWindow);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuffer result = new StringBuffer();
		int i = 0;
		for (String s : orths)
			if (i++ == keywordIndex)
				result.append("*** " + s + " *** ");
			else
				result.append(s + " ");
		result.append("\n");
		return result.toString();
	}

}
