/*
 * 
 *  Copyright (C) 2011 Mateusz Kopec
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 */
package resources;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

/**
 * Provides synonyms in a general understaning - words semantically correlated
 * with given word
 * 
 * @author Mateusz Kopec
 * 
 */
public abstract class SynonymDictionary {

	/**
	 * Returns synonyms for given word
	 * 
	 * @param lemma
	 *            word
	 * @param onlyMonosemous
	 *            flag telling whether include only synonyms for monosemous word
	 * @return collection of synonyms
	 */
	public abstract Collection<String> getSynonymsForLemma(String lemma, boolean onlyMonosemous);

	/**
	 * Synonyms for given word
	 * 
	 * @author Mateusz Kopec
	 * 
	 */
	protected static class SynonymEntry implements Serializable {
		private static final long serialVersionUID = 1774232924397366986L;

		/**
		 * Synonyms
		 */
		public Collection<String> synonyms = new HashSet<String>();
		/**
		 * Is this word polysemous?
		 */
		public boolean isPolysemous = false;
	}
}
