/*
 * 
 *  Copyright (C) 2011 Mateusz Kopec
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 */

package basic;

import java.util.ArrayList;
import java.util.List;

/**
 * List of words, contains info about base forms and orthographical form
 * 
 * @author Mateusz Kopec
 * 
 */
public class WordList {

	protected List<String> orths;
	protected List<String> bases;

	/**
	 * Constructor to copy from another word list
	 * 
	 * @param wordlist
	 *            list to copy
	 */
	public WordList(WordList wordlist) {
		super();
		this.orths = new ArrayList<String>(wordlist.orths);
		this.bases = new ArrayList<String>(wordlist.bases);
	}

	/**
	 * Constructor
	 */
	public WordList() {
		super();
		this.orths = new ArrayList<String>();
		this.bases = new ArrayList<String>();
	}

	/**
	 * Adds word to the list
	 * 
	 * @param orth
	 *            orth form
	 * @param base
	 *            base form
	 */
	public void addWord(String orth, String base) {
		this.orths.add(orth);
		this.bases.add(base);
	}

	/**
	 * Gets bases of words in the list
	 * 
	 * @return bases
	 */
	public List<String> getBases() {
		return bases;
	}

	/**
	 * Gets orths of words in the list
	 * 
	 * @return orths
	 */
	public List<String> getOrths() {
		return orths;
	}
}
