package corpusapi;

import java.util.List;

public interface Corpus {
	/**
	 * Przygotowuje korpus do użycia, otwierając niezbędne pliki, do których ścieżka podana jest w konfiguracji.
	 * @param configFile ścieżka do pliku XML z konfiguracją korpusu
	 * @return true, jeśli operacja się powiodła, false w przeciwnym wypadku
	 */
	public boolean open();
	public boolean close();
	
	/**
	 * Zwraca obiekt klasy reprezentującej informacje meta o korpusie
	 * @return
	 */
	public CorpusHeader getCorpusHeader();
	public CorpusText getCorpusText(String textId);
	
	/**
	 * 
	 * @return
	 */
	public List<String> getCorpusTextIds();
	
	public boolean isCached();
	
	/**
	 * id korpusu podane w pliku konfiguracyjnym 
	 * @return id
	 */
	public String getId();
}
