/*
 * 
 *  Copyright (C) 2011 Mateusz Kopec
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 */
package utils;

import java.util.HashMap;
import java.util.Set;
import java.util.Map.Entry;

/**
 * Class for counting ocurrences of words
 * 
 * @author Mateusz Kopec
 * 
 */
public class Counter extends HashMap<String, Integer> {

	private static final long serialVersionUID = 1L;

	/**
	 * Add occurence for word
	 * 
	 * @param key
	 *            word
	 */
	public void increase(String key) {
		increase(key, 1);
	}

	/**
	 * Adds number of occurences for word
	 * 
	 * @param key
	 *            word
	 * @param amount
	 *            how many to add
	 */
	public void increase(String key, int amount) {
		if (containsKey(key)) {
			put(key, get(key) + amount);
		} else {
			put(key, amount);
		}
	}

	/**
	 * Add other counter to this one
	 * 
	 * @param another
	 *            counter
	 */
	public void addCounter(Counter another) {
		Set<java.util.Map.Entry<String, Integer>> entries = another.entrySet();
		for (Entry<String, Integer> entry : entries) {
			this.increase(entry.getKey(), entry.getValue());
		}
	}

}
