'''
Created on 09-03-2012

@author: mlenart
'''

import sys
import os
from utils import *

def _addHead(teiTree, groupId, target, headType):
    fsElem = xpath(teiTree, '//tei:seg[@xml:id=$id]/tei:fs', id=groupId)[0]
    if not xpath(fsElem, 'tei:f[@name=$headType]', target=target, headType=headType):
        fsElem.append(E.f(name=headType, fVal=target))
        fsElem[-1].tail = '\n'

def _doConvert(teiFile):
    teiTree = etree.parse(teiFile)
    for seg in xpath(teiTree, '//tei:seg'):
        groupId = xpath(seg, '@xml:id')[0]
        semheadTarget = xpath(seg, 'tei:ptr[@type="head" or @type="semh"]/@target')
        synheadTarget = xpath(seg, 'tei:ptr[@type="head" or @type="synh"]/@target')
        if semheadTarget:
            _addHead(teiTree, groupId, semheadTarget[0], 'semh')
        if synheadTarget:
            _addHead(teiTree, groupId, synheadTarget[0], 'synh')
        if xpath(seg, './/tei:f[@name="synh"]') and xpath(seg, './/tei:f[@name="semh"]'):
            fsElem = xpath(seg, './/tei:fs[@type="group"]')[0]
            fSemh = xpath(fsElem, './/tei:f[@name="semh"]')[0]
            fSynh = xpath(fsElem, './/tei:f[@name="synh"]')[0]
            fsElem.remove(fSynh)
            fsElem.remove(fSemh)
            fsElem.append(fSemh)
            fsElem.append(fSynh)
        for ptr in xpath(seg, 'tei:ptr'):
            target = ptr.attrib['target']
            if 'type' in ptr.attrib:
                del ptr.attrib['type']
    write_tree(teiTree, teiFile)

def correctGroupsFormat(teiRoot):
    for teiFile in execute('find "%s" -name "ann_groups.xml" | sort' % teiRoot):
        print 'converting', teiFile
        _doConvert(teiFile)
        
if __name__ == '__main__':
    teiRoot = sys.argv[1]
    correctGroupsFormat(teiRoot)
