
import os
from utils import *
import converter

E = ElementMaker(namespace=teins, nsmap={None:teins, 'xi':xins})

class NamesConverter(converter.Converter):
    
    def __init__(self, pmlpaths, path_to_save):
        super(NamesConverter, self).__init__(pmlpaths, path_to_save)
    
    @property
    def out_path(self):
        return os.path.join(self.wypluwka_path, 'ann_named.xml')
    
    @property
    def what(self):
        return 'named'
    
    def convert_sent(self, pmlsent):
        pid = pmlsent.attrib['id']
        sent_attrs = {
                         lxml_name(xmlns, 'id') : morph2id(pid, 'named'),
                         'corresp' : 'ann_morphosyntax.xml#' + pid
                         }
        teisent = E.s(**sent_attrs)
        
        foreign_edges_map = self.get_foreign_edges_map(pmlsent)
        
        for pmlne in sorted(xpath(pmlsent, './/pml:ne'), key=lambda ne: self.get_pml_tag_sort_key(ne)):
            neid = pmlne.attrib['id']
            teisent.append(self._convert_ne(pmlne, foreign_edges_map.get(neid, [])))
        
        return teisent

    def _convert_ne(self, pmlne, foreign_edges):
        netype = pmlne.attrib['type']
        neid = pmlne.attrib['id']
        subtype = pmlne.attrib.get(netype + 'Type', None)
        if xpath(pmlne, 'pml:derivType'):
            derivType = xpath(pmlne, 'pml:derivType')[0].text
            if xpath(pmlne, 'pml:derivedFrom'):
                derivedFrom = xpath(pmlne, 'pml:derivedFrom')[0].text
    #           if derivedFrom is None:
    #               derivedFrom = ''
            else:
                derivedFrom = ''
        else:
            derivType, derivedFrom = None, None
        orth = xpath(pmlne, 'pml:orth')[0].text
        
        if netype in ['date', 'time']:
            base = None
            if xpath(pmlne, 'pml:when/text()'):
                when = xpath(pmlne, 'pml:when')[0].text
            elif xpath(pmlne, '@when'):
                when = pmlne.attrib['when']
            else:
                when = ''
        else:
            base = xpath(pmlne, 'pml:base')[0].text
            when = None
        
        if xpath(pmlne, 'pml:cert/text()'):
            certainty = xpath(pmlne, 'pml:cert')[0].text
        else:
            certainty = ''
        
        if xpath(pmlne, 'pml:certComment/text()'):
            comment = xpath(pmlne, 'pml:certComment')[0].text
        else:
            comment = ''
        
        ne_attrs = {lxml_name(xmlns, 'id') : morph2id(neid, 'named')}
        teine = E.seg(E.fs(
                        E.f(E.symbol(value=netype), name='type'),
                        E.f(E.string(orth), name='orth'),
                        E.f(E.string(base), name='base') if when == None else E.f(E.string(when), name='when'),
                        E.f(E.symbol(value=certainty), name='certainty'),
                        type='named'),
                        *self.get_child_ptrs(pmlne, foreign_edges),
                        **ne_attrs
                        )
        fsnode = xpath(teine, 'tei:fs')[0]
    
        if comment:
            fsnode.insert(4, E.f(E.string(comment), name='comment'))
            
        if subtype:
            fsnode.insert(1, E.f(E.symbol(value=subtype), name='subtype'))
        
        if derivType:
            derivNode = E.f(
                            E.fs(
                                 E.f(E.symbol(value=derivType), name='derivType'),
                                 E.f(E.string(derivedFrom), name='derivedFrom'),
                                 type='derivation'
                                 ),
                            name='derived'
                            )
            fsnode.insert(0, derivNode)
        
        return teine
