'''
Created on 09-03-2012

@author: mlenart
'''

import sys
import subprocess
import logging

import correctGroupsFormat
import correctHeads
import correctRefs

def postprocess(teiRoot, pmlRoot):
    subprocess.check_call('./correctGroupNames.sh "%s"' % teiRoot, shell=True)
    print 'corrected group names'
    correctGroupsFormat.correctGroupsFormat(teiRoot)
    print 'corrected groups format'
    correctRefs.correctRefs(teiRoot, pmlRoot)
    print 'corrected refs'
    correctHeads.correctHeads(teiRoot, pmlRoot)
    print 'corrected heads'

if __name__ == "__main__":
    TEI_ROOT = sys.argv[1]
    PML_ROOT = sys.argv[2]
    print
    print 'START:', TEI_ROOT
    try:
        postprocess(TEI_ROOT, PML_ROOT)
    except:
        print >> sys.stderr, 'FAILED:', TEI_ROOT
        raise
    print 'END:', TEI_ROOT
    print
