package pl.waw.ipipan.zil.core.mmax2tei;

import java.io.File;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.log4j.Logger;

import pl.waw.ipipan.zil.core.mmaxAPI.Reader;

public class Mmax2Tei {

	final private static Logger logger = Logger.getLogger(Mmax2Tei.class);

	public static void main(String[] args) {

		if (args.length != 2) {
			logger.error("Wrong number of arguments! Should be: mmax2tei mmaxDir targetDir");
			return;
		}

		File mmaxManual = new File(args[0]);
		File teiManual = new File(args[1]);

		if (!mmaxManual.isDirectory()) {
			logger.error(mmaxManual + " is not a directory!");
			return;
		}
		if (!teiManual.isDirectory()) {
			logger.error(teiManual + " is not a directory!");
			return;
		}

		Map<String, String> texts = Reader.findMmaxTexts(mmaxManual);
		logger.info("Found " + texts.size() + " mmax texts in dir "
				+ mmaxManual);

		int errors = 0;
		for (Entry<String, String> e : texts.entrySet()) {
			try {
				convertText(e.getKey(), e.getValue(), teiManual);
			} catch (Exception e1) {
				logger.error("Error converting text " + e.getKey() + ": "
						+ e1.getLocalizedMessage());
				errors++;
			}
		}

		logger.info("Succesfully converted " + (texts.size() - errors)
				+ " texts");
		logger.info("Errors for " + errors + " texts");
	}

	private static void convertText(String textName, String mmaxFilePath,
			File targetDir) throws Exception {

		File mmaxFile = new File(mmaxFilePath);
		if (!mmaxFile.isFile())
			throw new Exception("Mmax file doesn't exist!");

		File parentDir = mmaxFile.getParentFile();
		if (parentDir == null || !parentDir.isDirectory())
			throw new Exception("Mmax file parent dir doesn't exist!");

		File mentions = new File(parentDir, textName + "_mentions.xml");
		File words = new File(parentDir, textName + "_words.xml");

		if (!mentions.isFile())
			throw new Exception("Mentions file doesn't exist!");
		if (!words.isFile())
			throw new Exception("Words file doesn't exist!");

		File targetTextDir = new File(targetDir, textName);
		if (!targetTextDir.isDirectory() && !targetTextDir.mkdir())
			throw new Exception("Problem creating target tei dir!");

		Converter.convertText(mentions, words, mmaxFile, targetTextDir);
	}
}
