package pl.waw.ipipan.zil.core.mmax2tei;

import ipipan.clarin.tei.api.entities.TEICorpusText;
import ipipan.clarin.tei.api.exceptions.TEIException;
import ipipan.clarin.tei.api.io.TEI_IO;
import ipipan.clarin.tei.api.io.TEI_IO.CompressionMethod;

import java.io.File;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TeiSaver {

	private static Logger logger = Logger.getLogger(TeiSaver.class);

	final private static boolean GZIP = true;
	final private static TEI_IO teiIO = TEI_IO.getInstance();

	public static void save(TEICorpusText resultText, File targetDir)
			throws TEIException {
		logger.debug("Saving text in " + targetDir);
		CompressionMethod cm = CompressionMethod.NONE;
		if (GZIP)
			cm = CompressionMethod.GZIP;
		teiIO.writeToNKJPDirectory(resultText, targetDir, cm);
	}

	public static Document createHeader(String title, String catRef)
			throws ParserConfigurationException {

		DocumentBuilderFactory docFactory = DocumentBuilderFactory
				.newInstance();
		DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

		// root elements
		Document doc = docBuilder.newDocument();
		Element e = doc.createElement("teiHeader");
		e.setAttribute("xmlns", "http://www.tei-c.org/ns/1.0");
		e.setAttribute("xmlns:nkjp", "http://www.nkjp.pl/ns/1.0");
		e.setAttribute("xml:lang", "en");

		Element f = doc.createElement("fileDesc");
		Element g = doc.createElement("titleStmt");
		Element h = doc.createElement("title");
		h.setTextContent(title);
		g.appendChild(h);
		f.appendChild(g);
		e.appendChild(f);

		f = doc.createElement("profileDesc");
		g = doc.createElement("textClass");
		h = doc.createElement("catRef");
		h.setAttribute("scheme", "#taxonomy-CORE");
		h.setAttribute("target", catRef);
		g.appendChild(h);
		f.appendChild(g);
		e.appendChild(f);

		f = doc.createElement("revisionDesc");
		e.appendChild(f);

		doc.appendChild(e);
		return doc;
	}
}
