/*
 * Decompiled with CFR 0.152.
 */
package pl.waw.ipipan.zil.core.mmaxAPI;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pl.waw.ipipan.zil.core.mmaxAPI.types.Mention;
import pl.waw.ipipan.zil.core.mmaxAPI.types.Word;

public class Reader {
    private static final Logger logger = Logger.getLogger(Reader.class);

    public static Map<String, String> findMmaxTexts(File mmaxDir) {
        HashMap<String, String> result = new HashMap<String, String>();
        Reader.recfindMmaxTexts(mmaxDir, result);
        return result;
    }

    private static void recfindMmaxTexts(File mmaxDir, Map<String, String> accumulator) {
        Object[] files = mmaxDir.listFiles();
        Arrays.sort(files);
        for (Object f : files) {
            if (((File)f).isFile() && ((File)f).getName().matches(".+\\.mmax")) {
                accumulator.put(((File)f).getName().substring(0, ((File)f).getName().lastIndexOf(".")), ((File)f).getAbsolutePath());
                continue;
            }
            if (!((File)f).isDirectory()) continue;
            Reader.recfindMmaxTexts((File)f, accumulator);
        }
    }

    public static Document loadDocument(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(xmlFile);
        doc.normalize();
        return doc;
    }

    public static List<Mention> loadMentions(File mentions) throws ParserConfigurationException, SAXException, IOException {
        logger.debug((Object)("Loading mentions from file " + mentions));
        ArrayList<Mention> result = new ArrayList<Mention>();
        Document doc = Reader.loadDocument(mentions);
        NodeList nl = doc.getElementsByTagName("markable");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node elem = nl.item(i);
            if (elem.getNodeType() != 1) continue;
            Element mention = (Element)elem;
            String id = mention.getAttribute("id");
            String span = mention.getAttribute("span");
            String mentionHead = mention.getAttribute("mention_head");
            String nearIdentity = mention.getAttribute("near_identity");
            String mentionGroup = mention.getAttribute("mention_group");
            String bartMentionGroup = mention.getAttribute("coref_set");
            String dominant = mention.getAttribute("dominant");
            String comment = mention.getAttribute("comment");
            Mention m = new Mention(id, span, mentionHead, nearIdentity, mentionGroup, bartMentionGroup, dominant, comment);
            result.add(m);
        }
        return result;
    }

    public static List<Word> loadWords(File words) throws ParserConfigurationException, SAXException, IOException {
        logger.debug((Object)("Loading words from file " + words));
        ArrayList<Word> result = new ArrayList<Word>();
        Document doc = Reader.loadDocument(words);
        NodeList nl = doc.getElementsByTagName("word");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node elem = nl.item(i);
            if (elem.getNodeType() != 1) continue;
            Element word = (Element)elem;
            String id = word.getAttribute("id");
            String base = word.getAttribute("base");
            String ctag = word.getAttribute("ctag");
            String msd = word.getAttribute("msd");
            String orth = word.getTextContent();
            boolean hasNps = word.getAttribute("hasNps").equals("true");
            boolean isLastInPar = word.getAttribute("lastInPar").equals("true");
            boolean isLastInSent = word.getAttribute("lastInSent").equals("true");
            Word w = new Word(id, orth, base, ctag, msd, hasNps, isLastInPar, isLastInSent);
            result.add(w);
        }
        return result;
    }

    public static List<String> parseSpan(String span, List<String> words) {
        ArrayList<String> parsed = new ArrayList<String>();
        for (String fragment : span.split(",")) {
            String last;
            String[] spl = fragment.split("\\.\\.");
            String first = spl[0];
            if (first.equals(last = spl[spl.length - 1])) {
                parsed.add(first);
                continue;
            }
            Iterator<String> it = words.iterator();
            String curr = it.next();
            while (!curr.equals(first)) {
                curr = it.next();
            }
            parsed.add(first);
            while (!curr.equals(last)) {
                curr = it.next();
                parsed.add(curr);
            }
        }
        return parsed;
    }

    public static Map<Mention, List<Word>> parseAllSpans(List<Word> mmaxWords, List<Mention> mmaxMentions) {
        HashMap<String, Word> wordId2Word = new HashMap<String, Word>();
        ArrayList<String> wordIds = new ArrayList<String>();
        for (Word w : mmaxWords) {
            String id = w.getId();
            wordId2Word.put(id, w);
            if (wordIds.contains(id)) {
                logger.error((Object)("Duplicate word id: " + id));
            }
            wordIds.add(id);
        }
        HashMap<Mention, List<Word>> result = new HashMap<Mention, List<Word>>();
        for (Mention m : mmaxMentions) {
            List<String> spanIds = Reader.parseSpan(m.getSpan(), wordIds);
            ArrayList span = new ArrayList();
            for (String id : spanIds) {
                span.add(wordId2Word.get(id));
            }
            result.put(m, span);
        }
        return result;
    }
}

