package pl.waw.ipipan.zil.core.mmaxAPI;

import java.io.File;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Writer {

	final private static Logger logger = Logger.getLogger(Writer.class);

	final private static TransformerFactory tFactory = TransformerFactory
			.newInstance();

	// TODO : extract mmax format specific parts from tei2mmax

	public static void saveDocument(Document doc, File result)
			throws TransformerException {
		Transformer transformer = tFactory.newTransformer();
		transformer.setOutputProperty(
				"{http://xml.apache.org/xslt}indent-amount", "2");
		transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		transformer.setOutputProperty(OutputKeys.METHOD, "xml");
		DOMSource s = new DOMSource(doc);
		StreamResult str = new StreamResult(result);
		if (result.getName().endsWith("_words.xml"))
			transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM,
					"words.dtd");
		transformer.transform(s, str);
	}

	public static Document createHeader(String title, String catRef,
			String wordsFile) throws ParserConfigurationException {

		DocumentBuilderFactory docFactory = DocumentBuilderFactory
				.newInstance();
		DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

		// root elements
		Document doc = docBuilder.newDocument();
		Element e = doc.createElement("mmax_project");

		Element f = doc.createElement("words");
		f.setTextContent(wordsFile);
		e.appendChild(f);

		f = doc.createElement("title");
		f.setAttribute("val", title);
		e.appendChild(f);

		f = doc.createElement("catRef");
		f.setAttribute("val", catRef);
		e.appendChild(f);

		doc.appendChild(e);
		return doc;
	}
}
