
PRAGMA foreign_keys = ON;

CREATE TABLE t_Main (
	Entry TEXT, 
	Id INTEGER PRIMARY KEY, 
	'User' TEXT, 
	Typ INTEGER, 
	Dok_i_NDok INTEGER
);

CREATE TABLE t_Desc (
	Nr_Desc INTEGER PRIMARY KEY, 
	Desc TEXT, 
	Example TEXT
);

CREATE TABLE t_Schem (
	Nr_Schem INTEGER PRIMARY KEY, 
	Schema TEXT,
	UNIQUE(Schema)
);

CREATE TABLE t_Link (
	Id INTEGER,
	Nr_Schem INTEGER,
	Nr_Desc INTEGER,
	FOREIGN KEY (Id) REFERENCES t_Main(Id),
	FOREIGN KEY (Nr_Schem) REFERENCES t_Schem(Nr_Schem), 
	FOREIGN KEY (Nr_Desc) REFERENCES t_Desc(Nr_Desc),
	UNIQUE (Id, Nr_Schem, Nr_Desc),
	UNIQUE (Nr_Desc)
);

CREATE TABLE t_SchemDesc (
	Nr_Desc INTEGER,
	Nr_Symb INTEGER, 
	SymbDesc TEXT,
	FOREIGN KEY(Nr_Desc) REFERENCES t_Desc(Nr_Desc)
	--~ UNIQUE(Nr_Desc, Nr_Symb)
);

CREATE TABLE t_SchemAtt (
	Nr_Desc INTEGER,
	Nr_Symb INTEGER, 
	Abstr INTEGER, 
	nAbstr INTEGER, 
	Anim INTEGER, 
	nAnim INTEGER, 
	Hum INTEGER, 
	nHum INTEGER, 
	Coll INTEGER, 
	Elm INTEGER, 
	Fl INTEGER, 
	Inf INTEGER, 
	Instit INTEGER, 
	Instr INTEGER, 
	Liqu INTEGER, 
	Mach INTEGER, 
	Mat INTEGER, 
	Pars INTEGER,
	FOREIGN KEY(Nr_Desc) REFERENCES t_Desc(Nr_Desc)
	--~ UNIQUE(Nr_Desc, Nr_Symb)
);

CREATE INDEX 't_Link_Id' ON 't_Link' ('Id' );
CREATE UNIQUE INDEX 't_Link_nr_opisu' ON 't_Link' ('Nr_Desc' );
CREATE INDEX 't_Link_nr_sch' ON 't_Link' ('Nr_Schem' );
CREATE UNIQUE INDEX 't_Link_PrimaryKey' ON 't_Link' ('Nr_Desc' );
CREATE UNIQUE INDEX 't_Main_haslo' ON 't_Main' ('Entry' );
CREATE UNIQUE INDEX 't_Main_Id' ON 't_Main' ('Id' );
CREATE UNIQUE INDEX 't_Main_PrimaryKey' ON 't_Main' ('Entry' , 'Id' );
CREATE UNIQUE INDEX 't_Desc_nr_opisu' ON 't_Desc' ('Nr_Desc' );
CREATE UNIQUE INDEX 't_Desc_PrimaryKey' ON 't_Desc' ('Nr_Desc' );
CREATE UNIQUE INDEX 't_Schem_nr_schem' ON 't_Schem' ('Nr_Schem' );
CREATE UNIQUE INDEX 't_Schem_PrimaryKey' ON 't_Schem' ('Schema' );
CREATE INDEX 't_SchemDesc_nr_opisu' ON 't_SchemDesc' ('Nr_Desc' );
CREATE INDEX 't_SchemAtt_nr_opisu' ON 't_SchemAtt' ('Nr_Desc' );
