#-*- coding: utf-8 -*-
'''
Created on Jan 25, 2013

@author: lennyn
'''
import os
import sqlite3
from const import DB_FILE
import schema
import schemaParser
import teiWriter
import pyparsing

ATTRS = ['Abstr', 'nAbstr', 'Anim', 'nAnim', 'Hum', 'nHum', 'Coll', 'Elm', 'Fl', 'Inf', 'Instit', 'Instr', 'Liqu', 'Mach', 'Mat', 'Pars']

class SemanticAttrsException(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)

def getSchemaText(conn, nrSchem):
#    print "SELECT schema FROM t_schem WHERE nr_schem = {0};".format(nrSchem)
    res = list(conn.execute("SELECT schema FROM t_schem WHERE nr_schem = {0};".format(nrSchem)))[0][0]
    return res

def getDescAndExample(conn, id, nrSchem, nrDesc):
    res = list(conn.execute('SELECT d.desc, d.example FROM t_desc d, t_link l WHERE l.id={0} AND l.nr_schem={1} AND l.nr_desc = d.nr_desc AND l.nr_desc = {2};'.format(id, nrSchem, nrDesc)))[0]
    return res
    
def getSenses(conn, id, lemma):
    res = []
    for nrSchem, nrDesc in conn.execute('SELECT nr_schem, nr_desc FROM t_link WHERE id = {0};'.format(id)):
        schemaText = None
        definition = None
        example = None
        try:
            schemaText = getSchemaText(conn, nrSchem)
            definition, example = getDescAndExample(conn, id, nrSchem, nrDesc)
            schemaTree = schemaParser.parseSchema(schemaText)
#            print nrDesc
            readSchemaAttrs(conn, schemaText, schemaTree, nrDesc, lemma)
            readSchemaDescs(conn, schemaText, schemaTree, nrDesc, lemma)
            sense = schema.Sense(definition, example, schemaTree)
            res.append(sense)
        except pyparsing.ParseException:
            print 'PARSE ERROR:::', lemma.encode('utf-8'), schemaText.encode('utf-8')
        except SemanticAttrsException:
            print 'SEMANTIC ATTRS ERROR:::', lemma.encode('utf-8'), schemaText.encode('utf-8')
        except:
            print 'ERROR:::', nrSchem, lemma.encode('utf-8'), schemaText.encode('utf-8')
            raise
    return res

def readSchemaAttrs(conn, schemaText, schemaTree, nrDesc, lemma):
    phrases = schemaTree.getPhrases()
    for row in conn.execute('SELECT * FROM t_schematt WHERE nr_desc = {0} ORDER BY nr_symb;'.format(nrDesc)):
        attrIdxs = [idx for idx, val in enumerate(row[2:]) if val == 1]
        attrs = [ATTRS[attrIdx] for attrIdx in attrIdxs]
        phraseIdx = row[1] - 1
        if phraseIdx >= len(phrases):
            print 'SEMANTIC ATTRS ERROR:::', schemaText.encode('utf-8'), lemma.encode('utf-8'), row[1], attrs
            for phrase in phrases:
                phrase.semanticAttrs = set()
            return
        phrase = phrases[phraseIdx]
        if attrs:
            phrase.semanticAttrs.add(frozenset(attrs))
        assert all(map(lambda attrs: len(attrs) >= 1, attrs))
#        print schemaText.encode('utf-8'), lemma.encode('utf-8'), phrase.label, attrs

def readSchemaDescs(conn, schemaText, schemaTree, nrDesc, lemma):
    phrases = schemaTree.getPhrases()
    for row in conn.execute('SELECT * FROM t_schemdesc WHERE nr_desc = {0} ORDER BY nr_symb;'.format(nrDesc)):
#        print schemaText.encode('utf-8'), lemma.encode('utf-8'), list(schemAttr)
        phraseIdx = row[1] - 1
        desc = row[2]
        if phraseIdx >= len(phrases):
            print 'SEMANTIC DESCS ERROR:::', schemaText.encode('utf-8'), lemma.encode('utf-8'), row[1], desc
            for phrase in phrases:
                phrase.semanticDescs = set()
            return
        phrase = phrases[phraseIdx]
        phrase.semanticDescs.add(desc)

def getEntries(conn):
    res = []
#    print list(conn.execute("SELECT * FROM sqlite_master WHERE type='table';"))
    for id, lemma in conn.execute(u"SELECT id, entry FROM t_main ORDER BY entry;"):
    #~ for id, lemma in conn.execute(u"SELECT id, entry FROM t_main WHERE entry LIKE 'baga%';"):
    #~ for id, lemma in conn.execute(u"SELECT id, entry FROM t_main WHERE entry LIKE 'zaczeka%';"):
    #~ for id, lemma in conn.execute(u"SELECT id, entry FROM t_main;"):
        senses = getSenses(conn, id, lemma)
        res.append(schema.Entry(lemma, senses))
    return res

print os.path.isfile(DB_FILE)
conn = sqlite3.connect(DB_FILE)
try:
    entries = getEntries(conn)
    teiWriter.writeDictionary('dictionary.xml', entries)
finally:
    conn.close()
