'''
Created on Jan 23, 2013

@author: lennyn
'''

class ElemType:
    atLeastOneOf = 'atLeastOneOf'
    concatenation = 'concatenation'
    oneOf = 'oneOf'
    list = 'list'
    optional = 'optional'
    unordered = 'unordered'

class Entry:
    
    def __init__(self, orth, senses=[]):
        self.orth = orth
        self.senses = senses

class Sense:
    
    def __init__(self, definition, example, schema):
        self.definition = definition
        self.example = example
        self.schema = schema
    
class Schema:
    
    def __init__(self, elements, schemaText, offsets):
        self.children = elements
    
    def __str__(self):
        return u'<SCHEMA>\n' +u'\n'.join([elem.toString(2) for elem in self.children])
    
    def getPhrases(self):
        res = []
        for child in self.children:
            if child.isComplex():
                res.extend(child.getPhrases())
            elif child.isPhrase():
                res.append(child)
        return res

class SchemaElement:
    
    def __init__(self):
        pass
    
    def isComplex(self):
        return False
    
    def isPhrase(self):
        return False

class Phrase(SchemaElement):
    
    def __init__(self, label, semanticAttrs=[]):
        self.label = label
        self.semanticAttrs = set(semanticAttrs)
        self.semanticDescs = set([])
    
    def __str__(self):
        return self.label
    
    def toString(self, indent):
        return ' '*indent + self.label
    
    def isPhrase(self):
        return True

class Verb(SchemaElement):
    
    def __init__(self):
        pass
    
    def __str__(self):
        return '-'
    
    def toString(self, indent):
        return ' '*indent + '-'

class TextElement(SchemaElement):
    
    def __init__(self, text):
        self.text = text
    
    def __str__(self):
        return u'"{0}"'.format(self.text)
    
    def toString(self, indent):
        return u' '*indent + unicode(self)

class ComplexElement(SchemaElement):
    
    def __init__(self, elemType, children):
        self.type = elemType
        self.children = children
    
    def __str__(self):
        return self.toString(0)
    
    def toString(self, indent):
        return u'{0}<{1}>\n{2}'.format(
                                  ' ' * indent,
                                  self.type.upper(), 
                                  u'\n'.join([child.toString(indent+2) for child in self.children]))
    
    def isComplex(self):
        return True
    
    def getPhrases(self):
        res = []
        for child in self.children:
            if child.isComplex():
                res.extend(child.getPhrases())
            elif child.isPhrase():
                res.append(child)
        return res
