% $Id: birnam_run.pl,v 0.40 2009/10/07 15:20:08 wolinski Exp $
%
% Runtime parsera bottom-up generującego upakowany las drzew. 
%
%
% Copyright (C) 1997-2007 Marcin Woliński
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License version 2 as
% published by the Free Software Foundation.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
% MA 02110-1301, USA 
%
% In addition, as a special exception, the copyright holder gives
% permission to link the code of this program with the Morfeusz library
% (see http://www.nlp.ipipan.waw.pl/~wolinski/morfeusz), and distribute
% linked combinations including the two. You must obey the GNU General
% Public License in all respects for all of the code used other than
% Morfeusz. If you modify this file, you may extend this exception to
% your version of the file, but you are not obligated to do so. If you
% do not wish to do so, delete this exception statement from your
% version.

:- dynamic(forest/5).
:- dynamic(fail_goal/2).
%:- set_prolog_flag(unknown,fail).

parse(NT,Od,Do) :-
	goal(NT,Od,Do,_TrId).
%	format(user_error,"~Nfound: ~p~n", [goal(NT,Od,Do,TrId)]).
%	tell(zsyp),listing(forest),told,
%	trace,
%	gettree(NT,Od,Do,TrId,Drzewo).


% Predykat goal jest wywoływany, gdy reguła szuka następnego
% potrzebnego jej nieterminala.
%
% Goal jest szkieletyzowany, bo jeśli forest zawiera już jakiś łuk dla
% tego nieterminala, to znaczy, że goal było już wywoływane dla
% tego nieterminala w tym miejscu i już znamy odpowiedź.  Na tej
% zasadzie również Wn jest dopasowywane dopiero po sprawdzeniu, czy
% forest zawiera łuk dla danego nieterminala zaczynający się w danym
% miejscu.  Próba nowej analizy (parsegoal) jest podejmowana tylko w
% przeciwnym wypadku.

goal( Goal, W0, Wn, TrId ) :-
	skeletify(Goal,GoalSkel),
	(forest(GoalSkel, W0, W, _, TrId) *-> W=Wn, Goal=GoalSkel;
	    fail_goal(Goal,W0) -> fail;
	    parsegoal(GoalSkel, W0, Wn, TrId) *-> Goal=GoalSkel;
	    assertz(fail_goal(Goal,W0)), fail).

parsegoal( _Goal, W0, _Wn, TrId ) :-
	getinput(W0,W1,I,xinfo(XInfo)),
 	( forest(terminal(J),W0,W1, _, _), I=@=J
    *->
	fail
    ;
	new_edge_number(TrId),
	assert(forest(terminal(I),W0,W1,[dummy/xinfo(XInfo)],TrId) ),
 	terminal( W0, W1, TrId, I )).

parsegoal( Goal, W0, Wn, TrId ) :-
	forest( Goal, W0, Wn, _, TrId).

%checkforest( NT, Od, Do, Drzewa ) :-
%	skeletify(NT,NTSkel),
%	forest(NTSkel, Od, Do, Drzewa, ?), 
%	NTSkel =@= NT.

register( NT, Od, Do, NReg, Analiza, _ ) :-
	skeletify(NT,NTSkel),
	forest(NTSkel, Od, Do, Drzewa, TrId), NTSkel =@= NT, 
	!,
	(eqmember(NReg/Analiza, Drzewa) 
      -> 
%	print(NReg/Analiza), nl, 
	fail
      ;
	retract(forest(NT,Od,Do,Drzewa,TrId)),
	assert(forest(NT,Od,Do,[NReg/Analiza | Drzewa],TrId)),
	!, fail).
register( NT, Od, Do, NReg, Analiza, TrId ) :-
	new_edge_number(TrId),
	assert(forest(NT,Od,Do,[NReg/Analiza],TrId)).

initforest :- reset_edge_numbers.

dropforest :-
	retractall( forest(_,_,_,_,_) ),
	retractall( fail_goal(_,_) ).

dumpforest.
% dumpforest :-
% 	listing(forest),
% 	listing(fail_goal).

skeletify(T,S) :-
	functor(T, N, A),
	functor(S, N, A).

% lista Pałkowa:
pałkowa(X|_,X).
pałkowa(_|XX,X) :- !, pałkowa(XX,X).
pałkowa(X,X).

% member nieunifikujący

eqmember(E,[F|_]) :- E=@=F, !.
eqmember(E,[_|L]) :- eqmember(E,L).

% generator unikatowych identyfikatorów dla łuków lasu:

reset_edge_numbers :- 
	nb_setval(swigra_edge_number,0).
new_edge_number(N) :-
	nb_getval(swigra_edge_number, N),
	N1 is N+1,
	nb_setval(swigra_edge_number, N1).
get_edge_number(N) :-
	nb_getval(swigra_edge_number, N).


%%% Local Variables: 
%%% coding: utf-8
%%% mode: prolog
%%% End: 
