/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.captcha;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.component.html.util.HtmlComponentUtils;
import org.apache.myfaces.component.html.util.ParameterResourceHandler;
import org.apache.myfaces.custom.captcha.CAPTCHAComponent;
import org.apache.myfaces.custom.captcha.util.CAPTCHAImageGenerator;
import org.apache.myfaces.custom.captcha.util.CAPTCHAResponseStream;
import org.apache.myfaces.custom.captcha.util.CAPTCHATextGenerator;
import org.apache.myfaces.custom.captcha.util.ColorGenerator;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.renderkit.html.util.ResourceLoader;

public class CAPTCHARenderer
extends Renderer
implements ResourceLoader {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        CAPTCHAComponent captchaComponent = (CAPTCHAComponent)component;
        this.generateImageTag(context, captchaComponent);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
    }

    private void generateImageTag(FacesContext context, CAPTCHAComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map params = HtmlComponentUtils.getParameterMap((UIComponent)component);
        String captchaSessionKeyName = component.getCaptchaSessionKeyName();
        String width = component.getImageWidth();
        String height = component.getImageHeight();
        if (width == null) {
            width = "290";
        }
        if (height == null) {
            height = "81";
        }
        writer.startElement("img", (UIComponent)component);
        if (captchaSessionKeyName != null) {
            params.put("captchaSessionKeyName", captchaSessionKeyName);
        }
        AddResource addResource = AddResourceFactory.getInstance(context);
        String url = context.getExternalContext().encodeResourceURL(addResource.getResourceUri(context, new ParameterResourceHandler(this.getClass(), params)));
        writer.writeAttribute("src", (Object)url, null);
        writer.writeAttribute("width", (Object)width, null);
        writer.writeAttribute("height", (Object)height, null);
        writer.endElement("img");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String resourceUri) throws IOException {
        FacesContextFactory facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lifecycleFactory.getLifecycle(HtmlComponentUtils.getLifecycleId(servletContext));
        FacesContext facesContext = facesContextFactory.getFacesContext((Object)servletContext, (Object)request, (Object)response, lifecycle);
        facesContext.setResponseStream((ResponseStream)new CAPTCHAResponseStream((OutputStream)response.getOutputStream()));
        try {
            try {
                this.renderCAPTCHA(facesContext);
            }
            catch (IOException e) {
                throw new FacesException("Could not render the CAPTCHA : " + e.getMessage(), (Throwable)e);
            }
            facesContext.getResponseStream().close();
        }
        finally {
            facesContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderCAPTCHA(FacesContext facesContext) throws IOException {
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        ResponseStream out = facesContext.getResponseStream();
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String captchaSessionKeyName = requestMap.get("captchaSessionKeyName").toString();
        CAPTCHAImageGenerator captchaImageGenerator = new CAPTCHAImageGenerator();
        try {
            Color endingColor = ColorGenerator.generateRandomColor(null);
            Color startingColor = ColorGenerator.generateRandomColor(endingColor);
            String captchaText = CAPTCHATextGenerator.generateRandomText();
            captchaImageGenerator.generateImage(response, captchaText, startingColor, endingColor);
            facesContext.getExternalContext().getSessionMap().put(captchaSessionKeyName, captchaText);
        }
        finally {
            out.close();
            facesContext.responseComplete();
        }
    }
}

