/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.fileupload;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.myfaces.custom.fileupload.DiskStorageStrategy;
import org.apache.myfaces.custom.fileupload.StorageStrategy;
import org.apache.myfaces.custom.fileupload.UploadedFileDefaultImplBase;

public class UploadedFileDefaultFileImpl
extends UploadedFileDefaultImplBase {
    private static final long serialVersionUID = -6401426361519246443L;
    private transient DiskFileItem fileItem = null;
    private StorageStrategy storageStrategy;

    public UploadedFileDefaultFileImpl(FileItem fileItem) throws IOException {
        super(fileItem.getName(), fileItem.getContentType());
        this.fileItem = (DiskFileItem)fileItem;
        this.storageStrategy = new DiskStorageStrategy(){

            public File getTempFile() {
                return UploadedFileDefaultFileImpl.this.fileItem.getStoreLocation();
            }

            public void deleteFileContents() {
                UploadedFileDefaultFileImpl.this.fileItem.delete();
            }
        };
    }

    public byte[] getBytes() throws IOException {
        byte[] bytes = new byte[(int)this.getSize()];
        if (this.fileItem != null) {
            this.fileItem.getInputStream().read(bytes);
        }
        return bytes;
    }

    public InputStream getInputStream() throws IOException {
        return this.fileItem != null ? this.fileItem.getInputStream() : new ByteArrayInputStream(new byte[0]);
    }

    public long getSize() {
        return this.fileItem != null ? this.fileItem.getSize() : 0L;
    }

    public StorageStrategy getStorageStrategy() {
        return this.storageStrategy;
    }
}

