/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource2;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.component.MethodBindingToMethodExpression;
import org.apache.myfaces.component.MethodExpressionToMethodBinding;
import org.apache.myfaces.custom.schedule.ScheduleMouseEvent;
import org.apache.myfaces.custom.schedule.UIScheduleBase;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;

public class UISchedule
extends UIScheduleBase
implements Serializable,
ActionSource2 {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.UISchedule";
    private static final long serialVersionUID = -8333458172939036755L;
    private MethodBinding _actionListener;
    private ScheduleActionListener _scheduleListener = new ScheduleActionListener();
    private ScheduleEntry _submittedEntry;
    private Date _lastClickedDateAndTime = null;
    private MethodExpression _actionExpression;
    private MethodExpression _mouseListenerExpression;

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        FacesContext context = this.getFacesContext();
        if (event instanceof ScheduleMouseEvent) {
            ScheduleMouseEvent mouseEvent = (ScheduleMouseEvent)event;
            MethodBinding mouseListener = this.getMouseListener();
            if (mouseListener != null) {
                mouseListener.invoke(context, new Object[]{mouseEvent});
            }
        }
        if (event.isAppropriateListener((FacesListener)this._scheduleListener)) {
            event.processListener((FacesListener)this._scheduleListener);
        }
        super.broadcast(event);
        if (event instanceof ActionEvent) {
            ActionListener defaultActionListener;
            MethodBinding actionListener = this.getActionListener();
            if (actionListener != null) {
                actionListener.invoke(context, new Object[]{event});
            }
            if ((defaultActionListener = context.getApplication().getActionListener()) != null) {
                defaultActionListener.processAction((ActionEvent)event);
            }
        }
    }

    protected ScheduleEntry findEntry(String id) {
        if (id == null) {
            return null;
        }
        Iterator dayIterator = this.getModel().iterator();
        while (dayIterator.hasNext()) {
            ScheduleDay day = (ScheduleDay)dayIterator.next();
            Iterator iter = day.iterator();
            while (iter.hasNext()) {
                ScheduleEntry entry = (ScheduleEntry)iter.next();
                if (!id.equals(entry.getId())) continue;
                return entry;
            }
        }
        return null;
    }

    public void setAction(MethodBinding action) {
        if (action != null) {
            this.setActionExpression(new MethodBindingToMethodExpression(action));
        } else {
            this.setActionExpression(null);
        }
    }

    public MethodBinding getAction() {
        MethodExpression actionExpression = this.getActionExpression();
        if (actionExpression instanceof MethodBindingToMethodExpression) {
            return ((MethodBindingToMethodExpression)actionExpression).getMethodBinding();
        }
        if (actionExpression != null) {
            return new MethodExpressionToMethodBinding(actionExpression);
        }
        return null;
    }

    public MethodExpression getActionExpression() {
        if (this._actionExpression != null) {
            return this._actionExpression;
        }
        ValueExpression expression = this.getValueExpression("actionExpression");
        if (expression != null) {
            return (MethodExpression)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setActionExpression(MethodExpression actionExpression) {
        this._actionExpression = actionExpression;
    }

    public MethodExpression getMouseListenerExpression() {
        if (this._mouseListenerExpression != null) {
            return this._mouseListenerExpression;
        }
        ValueExpression expression = this.getValueExpression("mouseListenerExpression");
        if (expression != null) {
            return (MethodExpression)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setMouseListenerExpression(MethodExpression mouseListenerExpression) {
        this._mouseListenerExpression = mouseListenerExpression;
    }

    public MethodBinding getActionListener() {
        return this._actionListener;
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public Date getLastClickedDateAndTime() {
        return this._lastClickedDateAndTime;
    }

    public void setMouseListener(MethodBinding mouseListener) {
        if (mouseListener != null) {
            this.setMouseListenerExpression(new MethodBindingToMethodExpression(mouseListener));
        } else {
            this.setMouseListenerExpression(null);
        }
    }

    public MethodBinding getMouseListener() {
        MethodExpression mouseListenerExpression = this.getMouseListenerExpression();
        if (mouseListenerExpression instanceof MethodBindingToMethodExpression) {
            return ((MethodBindingToMethodExpression)mouseListenerExpression).getMethodBinding();
        }
        if (mouseListenerExpression != null) {
            return new MethodExpressionToMethodBinding(mouseListenerExpression);
        }
        return null;
    }

    protected ScheduleEntry getSubmittedEntry() {
        return this._submittedEntry;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ActionEvent || event instanceof ScheduleMouseEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    protected void resetMouseEvents() {
        this._lastClickedDateAndTime = null;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._lastClickedDateAndTime = (Date)values[1];
        this._actionListener = (MethodBinding)UISchedule.restoreAttachedState((FacesContext)context, (Object)values[2]);
        this._actionExpression = (MethodExpression)UISchedule.restoreAttachedState((FacesContext)context, (Object)values[3]);
        this._mouseListenerExpression = (MethodExpression)UISchedule.restoreAttachedState((FacesContext)context, (Object)values[4]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._lastClickedDateAndTime, UISchedule.saveAttachedState((FacesContext)context, (Object)this._actionListener), UISchedule.saveAttachedState((FacesContext)context, (Object)this._actionExpression), UISchedule.saveAttachedState((FacesContext)context, (Object)this._mouseListenerExpression)};
        return values;
    }

    public void setActionListener(MethodBinding actionListener) {
        this._actionListener = actionListener;
    }

    protected void setLastClickedDateAndTime(Date lastClickedDateAndTime) {
        this._lastClickedDateAndTime = lastClickedDateAndTime;
    }

    protected void setSubmittedEntry(ScheduleEntry submittedEntry) {
        this._submittedEntry = submittedEntry;
    }

    private class ScheduleActionListener
    implements ActionListener {
        private ScheduleActionListener() {
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            UISchedule schedule = (UISchedule)event.getComponent();
            ScheduleEntry entry = schedule.getSubmittedEntry();
            schedule.getModel().setSelectedEntry(entry);
            schedule.setSubmittedEntry(null);
        }
    }
}

