/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tabbedpane;

import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.component.AlignProperty;
import org.apache.myfaces.component.DataProperties;
import org.apache.myfaces.component.EventAware;
import org.apache.myfaces.component.PanelProperties;
import org.apache.myfaces.component.UniversalProperties;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.custom.tabbedpane.HtmlPanelTab;
import org.apache.myfaces.custom.tabbedpane.TabChangeEvent;
import org.apache.myfaces.custom.tabbedpane.TabChangeListener;

public abstract class AbstractHtmlPanelTabbedPane
extends HtmlPanelGroup
implements UniversalProperties,
EventAware,
PanelProperties,
AlignProperty,
DataProperties,
UserRoleAware {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlPanelTabbedPane";
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.TabbedPane";
    private static final int DEFAULT_SELECTEDINDEX = 0;
    private static final boolean DEFAULT_SERVER_SIDE_TAB_SWITCH = false;
    private MethodBinding _tabChangeListener = null;
    private static final int DEFAULT_BORDER = Integer.MIN_VALUE;

    public void decode(FacesContext context) {
        super.decode(context);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.decode(context);
        int tabIdx = 0;
        int selectedIndex = this.getSelectedIndex();
        Iterator it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent childOrFacet = this.getUIComponent((UIComponent)it.next());
            if (childOrFacet instanceof HtmlPanelTab) {
                if (this.isClientSide() || selectedIndex == tabIdx) {
                    childOrFacet.processDecodes(context);
                }
                ++tabIdx;
                continue;
            }
            childOrFacet.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        int tabIdx = 0;
        int selectedIndex = this.getSelectedIndex();
        Iterator it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent childOrFacet = this.getUIComponent((UIComponent)it.next());
            if (childOrFacet instanceof HtmlPanelTab) {
                if (this.isClientSide() || selectedIndex == tabIdx) {
                    childOrFacet.processValidators(context);
                }
                ++tabIdx;
                continue;
            }
            childOrFacet.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        int tabIdx = 0;
        int selectedIndex = this.getSelectedIndex();
        Iterator it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent childOrFacet = this.getUIComponent((UIComponent)it.next());
            if (childOrFacet instanceof HtmlPanelTab) {
                if (this.isClientSide() || selectedIndex == tabIdx) {
                    childOrFacet.processUpdates(context);
                }
                ++tabIdx;
                continue;
            }
            childOrFacet.processUpdates(context);
        }
    }

    private UIComponent getUIComponent(UIComponent uiComponent) {
        if (uiComponent instanceof UINamingContainer || uiComponent instanceof UIForm) {
            List children = uiComponent.getChildren();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                uiComponent = this.getUIComponent((UIComponent)children.get(i));
            }
        }
        return uiComponent;
    }

    public void addTabChangeListener(TabChangeListener listener) {
        this.addFacesListener(listener);
    }

    public void removeTabChangeListener(TabChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public MethodBinding getTabChangeListener() {
        return this._tabChangeListener;
    }

    public void setTabChangeListener(MethodBinding tabChangeListener) {
        this._tabChangeListener = tabChangeListener;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        TabChangeEvent tabChangeEvent;
        if (event instanceof TabChangeEvent && (tabChangeEvent = (TabChangeEvent)event).getComponent() == this) {
            this.setSelectedIndex(tabChangeEvent.getNewTabIndex());
            this.getFacesContext().renderResponse();
        }
        super.broadcast(event);
        MethodBinding tabChangeListenerBinding = this.getTabChangeListener();
        if (tabChangeListenerBinding != null) {
            try {
                tabChangeListenerBinding.invoke(this.getFacesContext(), new Object[]{event});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    public boolean isClientSide() {
        return !this.isServerSideTabSwitch();
    }

    public abstract String getActiveTabVar();

    public abstract Boolean getActivePanelTabVar();

    public abstract int getSelectedIndex();

    public abstract void setSelectedIndex(int var1);

    public abstract String getActiveTabStyleClass();

    public abstract String getInactiveTabStyleClass();

    public abstract String getActiveSubStyleClass();

    public abstract String getInactiveSubStyleClass();

    public abstract String getTabContentStyleClass();

    public abstract String getDisabledTabStyleClass();

    public abstract boolean isServerSideTabSwitch();

    public boolean getServerSideTabSwitch() {
        return this.isServerSideTabSwitch();
    }

    public abstract boolean isImmediateTabChange();

    public void queueEvent(FacesEvent event) {
        if (event != null && event instanceof TabChangeEvent) {
            if (this.isImmediateTabChange()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }
}

