/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp.filter;

import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import org.apache.myfaces.tomahawk.util.ExternalContextUtils;
import org.apache.myfaces.webapp.filter.PortletUtils;

class MultipartRequestWrapperConfig {
    private int _uploadMaxFileSize = 0x6400000;
    private int _uploadThresholdSize = 0x100000;
    private String _uploadRepositoryPath = null;
    private static final String UPLOAD_MAX_FILE_SIZE = "org.apache.myfaces.UPLOAD_MAX_FILE_SIZE";
    private static final String UPLOAD_THRESHOLD_SIZE = "org.apache.myfaces.UPLOAD_THRESHOLD_SIZE";
    private static final String UPLOAD_MAX_REPOSITORY_PATH = "org.apache.myfaces.UPLOAD_MAX_REPOSITORY_PATH";
    private static final String MULTIPART_REQUEST_WRAPPER_CONFIG = MultipartRequestWrapperConfig.class.getName();

    private MultipartRequestWrapperConfig() {
    }

    private static int resolveSize(String param, int defaultValue) {
        int numberParam = defaultValue;
        if (param != null) {
            param = param.toLowerCase();
            int factor = 1;
            String number = param;
            if (param.endsWith("g")) {
                factor = 0x40000000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("m")) {
                factor = 0x100000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024;
                number = param.substring(0, param.length() - 1);
            }
            numberParam = Integer.parseInt(number) * factor;
        }
        return numberParam;
    }

    public int getUploadMaxFileSize() {
        return this._uploadMaxFileSize;
    }

    public void setUploadMaxFileSize(int uploadMaxFileSize) {
        this._uploadMaxFileSize = uploadMaxFileSize;
    }

    public int getUploadThresholdSize() {
        return this._uploadThresholdSize;
    }

    public void setUploadThresholdSize(int uploadThresholdSize) {
        this._uploadThresholdSize = uploadThresholdSize;
    }

    public String getUploadRepositoryPath() {
        return this._uploadRepositoryPath;
    }

    public void setUploadRepositoryPath(String uploadRepositoryPath) {
        this._uploadRepositoryPath = uploadRepositoryPath;
    }

    public static MultipartRequestWrapperConfig getMultipartRequestWrapperConfig(ExternalContext context) {
        MultipartRequestWrapperConfig config = (MultipartRequestWrapperConfig)context.getApplicationMap().get(MULTIPART_REQUEST_WRAPPER_CONFIG);
        if (config == null) {
            config = new MultipartRequestWrapperConfig();
            if (!ExternalContextUtils.getRequestType(context).isPortlet()) {
                ServletContext servletContext = (ServletContext)context.getContext();
                String param = servletContext.getInitParameter(UPLOAD_MAX_FILE_SIZE);
                config._uploadMaxFileSize = MultipartRequestWrapperConfig.resolveSize(param, config._uploadMaxFileSize);
                param = servletContext.getInitParameter(UPLOAD_THRESHOLD_SIZE);
                config._uploadThresholdSize = MultipartRequestWrapperConfig.resolveSize(param, config._uploadThresholdSize);
                config._uploadRepositoryPath = servletContext.getInitParameter(UPLOAD_MAX_REPOSITORY_PATH);
                context.getApplicationMap().put(MULTIPART_REQUEST_WRAPPER_CONFIG, config);
            } else {
                Object portletContext = context.getContext();
                String param = PortletUtils.getContextInitParameter(portletContext, UPLOAD_MAX_FILE_SIZE);
                config._uploadMaxFileSize = MultipartRequestWrapperConfig.resolveSize(param, config._uploadMaxFileSize);
                param = PortletUtils.getContextInitParameter(portletContext, UPLOAD_THRESHOLD_SIZE);
                config._uploadThresholdSize = MultipartRequestWrapperConfig.resolveSize(param, config._uploadThresholdSize);
                config._uploadRepositoryPath = PortletUtils.getContextInitParameter(portletContext, UPLOAD_MAX_REPOSITORY_PATH);
                context.getApplicationMap().put(MULTIPART_REQUEST_WRAPPER_CONFIG, config);
            }
        }
        return config;
    }
}

