/*
 * Main.java
 *
 * Autor: Jan Szejko <j-sz małpa o2.pl>
 */
package dendrarium.commandline;

import dendrarium.core.entities.Answer;
import dendrarium.core.entities.TaskBusinessProcess;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

/**
 *
 * @author janek
 */
public class CheckTBPStates {

    private Session session;

    CheckTBPStates(Session session) {
        this.session = session;
    }

    void check() {
        session.beginTransaction();
        List<TaskBusinessProcess> badTBPs = findBadTBPs();
        for (TaskBusinessProcess tbp : badTBPs) {
            Answer a1 = tbp.getUser1Answer();
            Answer a2 = tbp.getUser2Answer();
            System.out.println("Błędny status");
            System.out.println("Id: " + tbp.getId());
            System.out.println("Packet id: " + tbp.getPacket());
            System.out.println("Stary tbp_state: " + tbp.getState().name());
            System.out.println("User1 Answer: " + a1.getId());
            System.out.println("Accepted: " + a1.isAccepted());
            System.out.println("Confirmed: " + a1.isConfirmed());
            System.out.println("Username: " + a1.getUser().getUsername());
            System.out.println("User2 Answer: " + a2.getId());
            System.out.println("Accepted: " + a2.isAccepted());
            System.out.println("Confirmed: " + a2.isConfirmed());
            System.out.println("Username: " + a2.getUser().getUsername());
            if (a1.isEquivalentTo(a2)) {
                System.out.println("Zgodność");
                if (tbp.getSuperAnswer() == null) {
                    System.out.println("Brak superodpowiedzi: dotwarzanie");
                    Answer finalAnswer = new Answer(tbp);
                    finalAnswer.setAnswer(a1.getAnswer());
                    finalAnswer.setType(a1.getType());
                    finalAnswer.setComment("AUTO");
                    finalAnswer.setAccepted(true);
                    session.persist(finalAnswer);
                    tbp.setSuperAnswer(finalAnswer);
                }
            } else {
                System.out.println("Niezgodność");
                Answer sa = tbp.getSuperAnswer();
                if (sa != null && sa.getUser() == null) {
                    System.out.println("Znaleziono automatyczną superodpowiedź: usuwanie");
                    tbp.setSuperAnswer(null);
                    session.delete(sa);
                }
            }
            tbp.updateState();
            System.out.println("Nowy tbp_state: " + tbp.getState().name());
        }
        session.getTransaction().commit();
        session.flush();
        session.clear();
    }

    private List<TaskBusinessProcess> findBadTBPs() {
        String query_text = "from TaskBusinessProcess tbp where \n"
                + "(tbp.state in (dendrarium.core.entities.TaskBusinessProcessState.INACCEPTANCE, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.COLLISION_SOLVED, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.AUTOACCEPTED) \n"
                + "and tbp.superAnswer is null) \n"
                + "or (tbp.state not in (dendrarium.core.entities.TaskBusinessProcessState.INACCEPTANCE, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.COLLISION_SOLVED, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.AUTOACCEPTED) \n"
                + "and tbp.superAnswer is not null) \n"
                + "or (tbp.state not in (dendrarium.core.entities.TaskBusinessProcessState.CLEAN, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.INPROGRESS_CLEAN, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.DONE_CLEAN) \n"
                + "and user2Answer is null) \n"
                + "or (tbp.state in (dendrarium.core.entities.TaskBusinessProcessState.CLEAN, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.INPROGRESS_CLEAN, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.DONE_CLEAN) \n"
                + "and user2Answer is not null) \n"
                + "or (tbp.state != dendrarium.core.entities.TaskBusinessProcessState.CLEAN \n"
                + "and user1Answer is null) \n"
                + "or (tbp.state = dendrarium.core.entities.TaskBusinessProcessState.CLEAN \n"
                + "and user1Answer is not null) \n"
                + "or (tbp.state in (dendrarium.core.entities.TaskBusinessProcessState.DONE_INPROGRESS, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.INPROGRESS_INPROGRESS) \n"
                + "and tbp.user2Answer.accepted = true) \n"
                + "or (tbp.state not in (dendrarium.core.entities.TaskBusinessProcessState.DONE_INPROGRESS, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.INPROGRESS_INPROGRESS) \n"
                + "and tbp.user2Answer.accepted = false) \n"
                + "or (tbp.state in (dendrarium.core.entities.TaskBusinessProcessState.INPROGRESS_CLEAN, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.INPROGRESS_DONE, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.INPROGRESS_INPROGRESS) \n"
                + "and tbp.user1Answer.accepted = true) \n"
                + "or (tbp.state not in (dendrarium.core.entities.TaskBusinessProcessState.INPROGRESS_CLEAN, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.INPROGRESS_DONE, \n"
                + "dendrarium.core.entities.TaskBusinessProcessState.INPROGRESS_INPROGRESS) \n"
                + "and tbp.user1Answer.accepted = false) \n"
                + "or (tbp.state = dendrarium.core.entities.TaskBusinessProcessState.COLLISION \n"
                + "and tbp.user1Answer.type = tbp.user2Answer.type and \n"
                + "(tbp.user1Answer.type != dendrarium.trees.AnswerType.FULL \n"
                + "or tbp.user1Answer.answerHash = tbp.user2Answer.answerHash)) \n"
                + "or (tbp.state = dendrarium.core.entities.TaskBusinessProcessState.AUTOACCEPTED \n"
                + "and not (tbp.user1Answer.type = tbp.user2Answer.type and \n"
                + "tbp.user1Answer.type != dendrarium.trees.AnswerType.FULL \n"
                + "or tbp.user1Answer.answerHash = tbp.user2Answer.answerHash)) \n"
                + "order by tbp.packet.id, tbp.id";
        Query q = session.createQuery(query_text);
        return q.list();
    }

}
