/*
 * Main.java
 *
 * Autor: Piotr Achinger <piotr.achinger at gmail.com>
 */
package dendrarium.commandline;

import dendrarium.trees.Forest;
import dendrarium.trees.xml.ForestExportFormat;
import dendrarium.trees.xml.TreeXMLExporter;
import dendrarium.trees.xml.TreeXMLParser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.hibernate.Session;

/**
 *
 * @author Piotr Achinger <piotr.achinger at gmail.com>
 */
public class Main {

    public static void main(String[] args) throws Exception {
        int argc = args.length;

        System.err.println("\n *\n * Dendrarium COMMAND-LINE\n *\n");

        if (argc < 1) {
            printUsage();
            System.exit(1);
        }

        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("config.properties"));
        } catch (IOException ex) {
            System.err.println("Error loading properties: " + ex.getMessage() + "\n");
        }
        for (String k : properties.stringPropertyNames()) {
            CommandLineHU.setProperty(k, properties.getProperty(k));
        }

        String command = args[0];

        if ("parse".equals(command)) {
            String filename = args[1];

            Forest forest = new TreeXMLParser().parse(new FileInputStream(filename));

            System.out.println(new TreeXMLExporter().export(forest, ForestExportFormat.FULL));
        } else if ("tomek".equals(command)) {
            //  StringUtils.join(Arrays.copyOfRange(words, from, to), " ");
       /*     List<String> sub1 = Arrays.asList("Ala", "ma", "kota", ",");
            ChildInfo childInfo1 = new ChildInfo("fno1", "bier1, dop1, czas1", "bier1, dop1", sub1);
            List<String> sub2 = Arrays.asList("a", "sierotka", "ma", "rysia", ".");
            ChildInfo childInfo2 = new ChildInfo("fno1", "bier1, dop1, czas1", "bier1, dop1", sub2);
            Document doc = new NodeTreeDrawer().getDocNodeTree("e1", (List<ChildInfo>) Arrays.asList(childInfo1, childInfo2));
            TreeOutputter.writePrettyFile("variant.svg", doc);*/

            //  String sentence = StringUtils.join(Arrays.copyOfRange(sub1.toArray(), 0, 4), " ");
            //   System.out.println(sentence);

//            Calendar now = Calendar.getInstance();
//            System.out.println("\nCurrent Year is : " + now.get(Calendar.YEAR));
//            System.out.println("\nCurrent Month is : " + (now.get(Calendar.MONTH) + 1));
//            System.out.println("\nCurrent Date is : " + now.get(Calendar.DATE));
            Date startDate;
            Date finishDate;
            Calendar cal = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
//        cal2.set( cal2.get( Calendar.YEAR), cal2.get(Calendar.MONTH), 1, 0,0);
            cal2.set(Calendar.DAY_OF_MONTH, 1);
            cal2.set(Calendar.HOUR, 0);
            cal2.set(Calendar.MINUTE, 0);

            Date now = new Date(cal.getTimeInMillis());
            System.out.println("now:date " + cal.get(Calendar.DATE));
            Long numAns;
            for (int i = 1 ; i <= cal.get(Calendar.DATE) ; i++) {
                startDate = new Date(cal2.getTimeInMillis());
                System.out.println("i: " + i + " day: " + cal2.get(Calendar.DATE) + " hour " + cal2.get(Calendar.HOUR) + " minute " + cal2.get(Calendar.MINUTE));
                cal2.add(Calendar.DAY_OF_MONTH, 1);
                finishDate = new Date(cal2.getTimeInMillis());
                if (now.after(startDate) && now.before(finishDate)) {
                    System.out.println("Day " + i + " between");

                }
            }

        } else if ("piotrek".equals(command)) {
            String filename = args[1];
            Forest forest = new TreeXMLParser().parse(new FileInputStream(filename));
            System.out.println(forest.wordRange(23, 14));
            System.out.println(forest.wordRange(0, 14));
        } else if ("upload".equals(command)) {
            if (argc < 2) {
                System.err.println("USAGE: upload <directory>");
                System.exit(1);
            }

            File directory = new File(args[1]);
            Session session = CommandLineHU.getCurrentSession();

            new CommandLineUpload(session).uploadDirectory(directory);
//            session.beginTransaction();
//
//            session.persist(packet);
//
//            session.flush();
//            session.getTransaction().commit();
        } else if ("update".equals(command)) {
            if (argc < 2) {
                System.err.println("USAGE: update <directory>");
                System.exit(1);
            }

            File directory = new File(args[1]);
            Session session = CommandLineHU.getCurrentSession();

            new CommandLineUpload(session).updateDirectory(directory);
        } else if ("export".equals(command)) {
            if (argc < 2) {
                System.err.println("USAGE: export <directory>");
                System.exit(1);
            }

            Session session = CommandLineHU.getCurrentSession();

            System.out.println("");
            new ExportAll(session).exportAll(args[1]);
        } else if ("tbp".equals(command)) {
            Session session = CommandLineHU.getCurrentSession();
            new CheckTBPStates(session).check();
        } else  {
            printUsage();
            System.exit(1);
        }
        System.err.println("\nDone.");
    }

    /**
     * Wypisuje skladnie wywolywania programu na standardowy strumien bledow.
     */
    private static void printUsage() {
        System.err.println(
                "Usage information: \n\n" +
                " java -jar Dendrarium.jar cmd args...\n");
    }
}
