/*
 * Packet.java
 *
 * Autor: Piotr Achinger <piotr.achinger at gmail.com>
 */
package dendrarium.core.entities;

import dendrarium.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Transient;

/**
 *
 * @author Piotr Achinger <piotr.achinger at gmail.com>
 */
@Entity
@javax.persistence.SequenceGenerator(name = "PACKET_SEQ",
                                     sequenceName = "packet_seq",
                                     allocationSize = 1)
public class Packet implements Serializable {

    private Long id;

    private String name;

    private ArrayList<String> paragraphText = new ArrayList<String>();

    /**
     * Ile lasow nie ma drzew
     */
    private int urbanizacja = 0;

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "PACKET_SEQ")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String text) {
        this.name = text;
    }

    public Packet(String text) {
        this.name = text;
    }

    public Packet() {
    }

//    @CollectionOfElements
    public ArrayList<String> getParagraphText() {
        return paragraphText;
    }

    public void setParagraphText(ArrayList<String> paragraphText) {
        this.paragraphText = paragraphText;
    }

    public int getUrbanizacja() {
        return urbanizacja;
    }

    public void setUrbanizacja(int urbanizacja) {
        this.urbanizacja = urbanizacja;
    }

    @Transient
    public String getStringParagraphText() {
        return StringUtils.join(this.getParagraphText().toArray(), " ");
    }

    @Transient
    public String getFirstSentence() {
        return this.getParagraphText().isEmpty() ? "" : this.getParagraphText().get(0);
    }

    @Transient
    public int getSize() {
        return this.paragraphText.size();
    }
}
