/*
 * Task.java
 *
 * Autor: Piotr Achinger <piotr.achinger at gmail.com>
 */
package dendrarium.core.entities;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Transient;
import org.hibernate.annotations.Immutable;
import org.hibernate.validator.Length;

/**
 * Zdanie + zbior drzew
 *
 * @author pta
 */
@Embeddable
public class Task implements Serializable {

    private String sentence;

    private String sent_id;

    private int grammar_no;

    private String forestXML;

    public Task() {
    }

    @Lob
    public String getSentence() {
        return sentence;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    @Lob
    @Immutable
    @Basic(fetch = FetchType.LAZY)
    public String getForestXML() {
        return forestXML;
    }

    public void setForestXML(String treeXML) {
        this.forestXML = treeXML;
    }

    @Immutable
    public int getGrammar_no() {
        return grammar_no;
    }

    public void setGrammar_no(int grammar_no) {
        this.grammar_no = grammar_no;
    }

    @Immutable
    public String getSent_id() {
        return sent_id;
    }

    public void setSent_id(String sent_id) {
        this.sent_id = sent_id;
    }

    @Override
    public String toString() {
        return "Task[" + sentence + "]";
    }

    @Transient
    String getDescription() {
        return sentence;
    }
}
