/*
 * TaskBusinessProcessState.java
 *
 * Autor: Dominika Pawlik
 */

package dendrarium.core.entities;

import java.util.EnumSet;

/**
 *
 * @author Piotr Achinger
 */
public enum TaskBusinessProcessState {
        CLEAN { //0
            public boolean check(TaskBusinessProcess tbp) {
                return tbp.getUser1Answer() == null &&
                        tbp.getUser2Answer() == null &&
                        tbp.getSuperAnswer() == null;
            }
        },
        INPROGRESS_CLEAN { //1
            public boolean check(TaskBusinessProcess tbp) {
                if (tbp.getUser1Answer() == null) return false;
                return !tbp.getUser1Answer().isAccepted() &&
                        tbp.getUser2Answer() == null &&
                        tbp.getSuperAnswer() == null;
            }
        },
        DONE_CLEAN { //2
            public boolean check(TaskBusinessProcess tbp) {
                if (tbp.getUser1Answer() == null) return false;
                return tbp.getUser1Answer().isAccepted() &&
                        tbp.getUser2Answer() == null &&
                        tbp.getSuperAnswer() == null;
            }
        },
        DONE_INPROGRESS { //3
            public boolean check(TaskBusinessProcess tbp) {
                if (tbp.getUser1Answer() == null) return false;
                if (tbp.getUser2Answer() == null) return false;
                return tbp.getUser1Answer().isAccepted() &&
                        !tbp.getUser2Answer().isAccepted() &&
                        tbp.getSuperAnswer() == null;
            }
        },
        INPROGRESS_DONE { //4
            public boolean check(TaskBusinessProcess tbp) {
                if (tbp.getUser1Answer() == null) return false;
                if (tbp.getUser2Answer() == null) return false;
                return !tbp.getUser1Answer().isAccepted() &&
                        tbp.getUser2Answer().isAccepted() &&
                        tbp.getSuperAnswer() == null;
            }
        },
        INPROGRESS_INPROGRESS { //5
            public boolean check(TaskBusinessProcess tbp) {
                if (tbp.getUser1Answer() == null) return false;
                if (tbp.getUser2Answer() == null) return false;
                return !tbp.getUser1Answer().isAccepted() &&
                        !tbp.getUser2Answer().isAccepted() &&
                        tbp.getSuperAnswer() == null;
            }
        },
        /**
         * UWAGA: ten stan nie jest już nigdy używany, zgodność zwóch odpowiedzi dendrologów
         * prowadzi do stanu AUTOACCEPTED
         */
//        AGREEMENT {
//            public boolean check(TaskBusinessProcess tbp) {
//                if (tbp.getUser1Answer() == null) return false;
//                if (tbp.getUser2Answer() == null) return false;
//                return tbp.getUser1Answer().isAccepted() &&
//                        tbp.getUser2Answer().isAccepted() &&
//                        tbp.getUser1Answer().isEquivalentTo(tbp.getUser2Answer()) &&
//                        tbp.getSuperAnswer() == null;
//            }
//        },
        COLLISION { //6
            public boolean check(TaskBusinessProcess tbp) {
                if (tbp.getUser1Answer() == null) return false;
                if (tbp.getUser2Answer() == null) return false;
                return tbp.getUser1Answer().isAccepted() &&
                        tbp.getUser2Answer().isAccepted() &&
                        // !tbp.getUser1Answer().isEquivalentTo(tbp.getUser2Answer()) &&
                        tbp.getSuperAnswer() == null;
            }
        },
        INACCEPTANCE { //7
            public boolean check(TaskBusinessProcess tbp) {
                if (tbp.getUser1Answer() == null) return false;
                if (tbp.getUser2Answer() == null) return false;
                if (tbp.getSuperAnswer() == null) return false;
                return !tbp.getSuperAnswer().isAccepted();
            }
        },
        COLLISION_SOLVED { //8
            public boolean check(TaskBusinessProcess tbp) {
                if (tbp.getUser1Answer() == null) return false;
                if (tbp.getUser2Answer() == null) return false;
                if (tbp.getSuperAnswer() == null) return false;
                if (!tbp.getSuperAnswer().isAccepted()) return false;
                return !tbp.getSuperAnswer().isEquivalentTo(tbp.getUser2Answer())
                        || !tbp.getSuperAnswer().isEquivalentTo(tbp.getUser1Answer());
                        
            }
        },
        AUTOACCEPTED { //9
            public boolean check(TaskBusinessProcess tbp) {
                if (tbp.getUser1Answer() == null) return false;
                if (tbp.getUser2Answer() == null) return false;
                if (tbp.getSuperAnswer() == null) return false;
                return tbp.getUser1Answer().isAccepted() &&
                        tbp.getUser2Answer().isAccepted() &&
                        tbp.getSuperAnswer().isEquivalentTo(tbp.getUser1Answer()) &&
                        tbp.getSuperAnswer().isEquivalentTo(tbp.getUser2Answer()) &&
                        tbp.getSuperAnswer().isAccepted();
            }
        },
        ILLEGALSTATE { //10
            public boolean check(TaskBusinessProcess tbp) {
                /* UWAGA */
                return tbp.getState() == ILLEGALSTATE;
            }
        };

        public static final EnumSet<TaskBusinessProcessState> LEGAL_STATES
                = EnumSet.complementOf(EnumSet.of(ILLEGALSTATE));

        public static final EnumSet<TaskBusinessProcessState> TERMINAL_STATES
                = EnumSet.of(COLLISION_SOLVED, AUTOACCEPTED);

        public static final EnumSet<TaskBusinessProcessState> DENDROLOG_RO_STATES
                = EnumSet.of(COLLISION_SOLVED, INACCEPTANCE);
       public abstract boolean check(TaskBusinessProcess tbp);
}
