/*
 * User.java
 *
 * Autor: Dominika Pawlik
 */
package dendrarium.core.entities;

import static org.jboss.seam.ScopeType.SESSION;

import java.io.Serializable;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;
import org.hibernate.validator.Pattern;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.security.management.UserPassword;
import org.jboss.seam.annotations.security.management.UserPrincipal;
import org.jboss.seam.annotations.security.management.UserRoles;

@Entity
@Name("user")
@Scope(SESSION)
@Table(name = "Dendrologist")
@NamedQueries({@NamedQuery(name = "login",
             query = "select u from User u where username=:username and password=:password"),
/*tb - wyszukaj dendrologow / */
@NamedQuery(name = "getDendrologs", query="select u from User u join u.roles r where r.rolename = 'dendrolog' order by u.username"),
             /*query = "select u from User u where (select r from Roles r where " +
             "r.rolename = 'dendrolog') member of u.roles")*/
@NamedQuery(name = "getSuperdendrologs", query="select u from User u join u.roles r where r.rolename = 'superdendrolog'")
})

public class User implements Serializable {

    private String username;

    private String password;

    private String name;

    private String info;

    private Set<Role> roles = new HashSet();
    int isDendrolog;

    public User(String name, String password, String username) {
        this.name = name;
        this.password = password;
        this.username = username;
        this.roles = new HashSet<Role>();
    }

    public User() {
    }

    @NotNull
    @Length(max = 100)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    @Length(min = 1, max = 15)
    @UserPassword
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Id
    @Length(min = 1, max = 15)
    @Pattern(regex = "^\\w*$", message = "not a valid username")
    @UserPrincipal
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Length(min = 0, max = 300)
    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    @Transient
    public String getRoleString() {
        StringBuilder sb = new StringBuilder();

        for (Role role : this.roles) {
            sb.append(role.getRolename() + " ");
        }

        return sb.toString().trim();
    }

    @Override
    public String toString() {
        return "User(" + username + ")";
    }

    @UserRoles
    @ManyToMany(targetEntity = Role.class)
    @JoinTable(name = "UserRoles",
               joinColumns = @JoinColumn(name = "Username"),
               inverseJoinColumns = @JoinColumn(name = "RoleId"))
    public Set<Role> getRoles() {
        return roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
//        isDendrolog = this.h;
    }

    /* ponizej pozostalosc kolumny ulubionego formatu eksportu; zostawiam
     * w celach edukacyjnych (pta)
     */
//    @Enumerated
//    @Column(columnDefinition="integer default 0")
//    public ForestExportFormat getPreferredExportFormat() {
}