/*
 * AnswerSearch.java
 *
 * Autor: Piotr Achinger <piotr.achinger at gmail.com>
 * Modyfikacja: janek37
 */
package dendrarium.portal;

import dendrarium.core.entities.Answer;
import dendrarium.core.entities.TaskBusinessProcess;
import dendrarium.core.entities.TaskBusinessProcessState;
import dendrarium.core.entities.User;
import dendrarium.trees.AnswerType;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.log.Log;

/**
 *
 * @author Piotr Achinger <piotr.achinger at gmail.com>
 */
@Name("answerSearch")
@Scope(ScopeType.SESSION)
public class AnswerSearch {

    private static final int PAGE_SIZE = 10;

    private List<AnswerType> answerTypeFilters;

    private AnswerType answerTypeFilter;

    private List<TaskBusinessProcessState> tbpStateFilters;

    private TaskBusinessProcessState tbpStateFilter;

    private List<User> userFilters;

    private String userFilter;

    private boolean onlyCurrent = true;

    private String filter = "";

    @RequestParameter
    public Integer page_no;

    //@DataModel
    //List<Answer> searchAnswers;

    //PaginatedList<Answer> searchAnswersPL;

    @DataModel
    List<TaskBusinessProcess> searchTBPs;

    PaginatedList<TaskBusinessProcess> searchTBPsPL;

    @In
    Session session;

    @Logger
    Log log;

    public AnswerSearch() {
        answerTypeFilters = Arrays.asList(AnswerType.values());
        answerTypeFilter = null;
        tbpStateFilters = Arrays.asList(TaskBusinessProcessState.values());
        tbpStateFilter = null;
        userFilters = null;
    }

    public Long listCount() {
        Criteria cr = makeCriteria();
        cr.setProjection(Projections.countDistinct("taskBusinessProcess"));
        return ((Integer) cr.uniqueResult()).longValue();
    }

    public Criteria makeCriteria() {
        Criteria criteria = session.createCriteria(Answer.class);

        criteria.createAlias("taskBusinessProcess", "tbp");

        criteria.add(Restrictions.isNotNull("answer"));

        criteria.add(Restrictions.eq("accepted", true));

        if (onlyCurrent) {
            criteria.add(Restrictions.eq("tbp.current", true));
        }

        if (answerTypeFilter != null) {
            criteria.add(Restrictions.eq("type", answerTypeFilter));
        }

        if (tbpStateFilter != null) {
            criteria.add(Restrictions.eq("tbp.state", tbpStateFilter));
        }

        // uwaga: paskudny hack (bo seam jest paskudny):

        if (userFilter != null) {
            String userFilterName = userFilter.substring(5, userFilter.length() - 1);

            log.info("userFilter: " + userFilterName);

            criteria.add(Restrictions.eq("user.username", userFilterName));
        }

        if (!filter.equals("")) {

            criteria.add(
                    Restrictions.or(
                    Property.forName("comment").like(filter, MatchMode.ANYWHERE),
                    Property.forName("tbp.task.sentence").like(filter, MatchMode.ANYWHERE)));
        }

        criteria.setProjection(Projections.groupProperty("taskBusinessProcess"));
        return criteria;
    }

    @Factory("searchTBPs")
    public void getSearchAnswers() { 


        //ScrollableResults allSearchTBPs = criteria.scroll();
        //List<TaskBusinessProcess> allSearchTBPs = criteria.list();
        searchTBPsPL = new PaginatedList<TaskBusinessProcess>(listCount(), makeCriteria(), PAGE_SIZE);
        getPage(0);
    }

    public void getPage(int page) {
        //searchAnswersPL.getPage(page);
        //searchAnswers = searchAnswersPL.getCurrentPage();
        searchTBPsPL.getPage(makeCriteria(), page);
        searchTBPs = searchTBPsPL.getCurrentPage();
    }

    public void getPage() {
        getPage(page_no);
    }

    public AnswerType getAnswerTypeFilter() {
        return answerTypeFilter;
    }

    public void setAnswerTypeFilter(AnswerType answerTypeFilter) {
        this.answerTypeFilter = answerTypeFilter;
    }

    public List<AnswerType> getAnswerTypeFilters() {
        return answerTypeFilters;
    }

    public void setAnswerTypeFilters(List<AnswerType> answerTypeFilters) {
        this.answerTypeFilters = answerTypeFilters;
    }

    public TaskBusinessProcessState getTbpStateFilter() {
        return tbpStateFilter;
    }

    public void setTbpStateFilter(TaskBusinessProcessState tbpStateFilter) {
        this.tbpStateFilter = tbpStateFilter;
    }

    public List<TaskBusinessProcessState> getTbpStateFilters() {
        return tbpStateFilters;
    }

    public void setTbpStateFilters(List<TaskBusinessProcessState> tbpStateFilters) {
        this.tbpStateFilters = tbpStateFilters;
    }

    public String getUserFilter() {
        return userFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public List<User> getUserFilters() {
        if (userFilters == null)
            userFilters = session.getNamedQuery("getDendrologs").list();
        return userFilters;
    }

    public void setUserFilters(List<User> userFilters) {
        this.userFilters = userFilters;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean getOnlyCurrent() {
        return onlyCurrent;
    }

    public void setOnlyCurrent(boolean onlyCurrent) {
        this.onlyCurrent = onlyCurrent;
    }

    public PaginatedList<TaskBusinessProcess> getSearchTBPsPL() {
        if (searchTBPsPL == null) {
            getSearchAnswers();
        }
        return searchTBPsPL;
    }
}
