package dendrarium.portal.answer;

import dendrarium.trees.svg.*;
import dendrarium.trees.NonterminalNode.ChoiceType;
import dendrarium.utils.Pair;
import java.util.LinkedList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;

/**
 *
 * @author Tomasz Badowski
 */
@Name("Legend")
@Scope(ScopeType.SESSION)
public class Legend {

    @Out(required = false)
    List<Pair<ChoiceType, String>> choiceTypes;

    @Factory(value = "choiceTypes")
    public void getChoiceTypes() {
        choiceTypes = new LinkedList<Pair<ChoiceType, String>>();
        for (ChoiceType c : ChoiceType.values()) {
            choiceTypes.add(new Pair(c.getDescription(),
                    DrawConfig.getFillColorByChoiceType(c)));
        }
    }
}
