package dendrarium.portal.collisions;

import dendrarium.core.entities.Answer;
import org.hibernate.Session;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.RaiseEvent;
import org.jboss.seam.annotations.web.RequestParameter;

/**
 *
 * @author pta
 */
@Name("confirmation")
public class Confirmation {

    @RequestParameter
    Long answerId;

    @In
    Session session;

    @RaiseEvent("tbpchangestate")
    public void confirm() {
        Answer answer = (Answer) session.get(Answer.class, answerId);

        answer.setConfirmed(true);
        answer.getTaskBusinessProcess().updateState();
        session.flush();
    }

}
