package dendrarium.portal.collisions;

import dendrarium.portal.answer.*;
import dendrarium.core.entities.Answer;
import dendrarium.core.entities.TaskBusinessProcess;
import java.io.Serializable;
import org.hibernate.Session;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.RaiseEvent;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;

@Name("workOnCollisionStateless")
@Scope(ScopeType.STATELESS)
public class WorkOnCollisionStateless implements Serializable {

    /* injected fields */
    @In
    Session session;

    @RequestParameter
    Long collisionId;


    @RaiseEvent("tbpchangestate")
    public void cancel() {
        TaskBusinessProcess tbp = (TaskBusinessProcess) session.get(TaskBusinessProcess.class, collisionId);
        cancel(tbp.getSuperAnswer());
    }

    @RaiseEvent("tbpchangestate")
    public void cancel(Answer answer) {
        answer = (Answer) session.merge(answer);
        answer.setAnswer(null);
        answer.getTaskBusinessProcess().updateState();
        session.flush();
    }

}
