/*
 * UserList.java
 *
 * Autor: Karolina Sołtys
 */
package dendrarium.portal.profile;

import dendrarium.core.entities.Packet;
import dendrarium.portal.PaginatedList;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.web.RequestParameter;

/**
 *
 * @author Dominika Pawlik
 */
@Name("packetList")
@Scope(ScopeType.SESSION)
public class PacketList implements Serializable {

    private static final int PAGE_SIZE = 10;

    @In
    Session session;

    @DataModel
    private List<Packet> packets;

    private PaginatedList<Packet> packetsPL;

    @RequestParameter
    public Integer page_no;

    @Factory("packets")
    @Observer("packetsListChange")
    public void getPackets() {
        List<Packet> allPackets = session.createQuery("from Packet").list();

        packetsPL = new PaginatedList<Packet>(allPackets, PAGE_SIZE);
        getPage(0);
    }

    private void getPage(int page_no) {
        packetsPL.getPage(page_no);
        packets = packetsPL.getCurrentPage();
    }

    public void getPage() {
        getPage(page_no);
    }

    public PaginatedList<Packet> getPacketsPL() {
        return packetsPL;
    }
}
