package dendrarium.portal.profile;

import dendrarium.core.entities.TaskBusinessProcess;
import dendrarium.core.entities.TaskBusinessProcessState;
import dendrarium.core.entities.User;
import dendrarium.core.entities.Answer;
import dendrarium.portal.answer.TreeRenderer;
import dendrarium.trees.NonterminalNode;
import dendrarium.trees.svg.SVGImage;
import dendrarium.trees.xml.TreeXMLParser;
import dendrarium.trees.AnswerType;
import java.io.Serializable;
import java.util.LinkedList;
import org.hibernate.Session;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;

/**
 *
 * @author Dominika Pawlik
 */
@Name("taskProfile")
@Scope(ScopeType.CONVERSATION)
public class TaskProfile implements Serializable {

    @In
    Identity identity;

    @In
    Session session;

    @In(create = true)
    TreeRenderer treeRenderer;

    @In
    User user;

    @Logger
    Log log;

    @In(required = false)
    @Out(required = false)
    TaskBusinessProcess t;

    @Out(required = false)
    String img1;

    @Out(required = false)
    String img2;

    @Out(required = false)
    String info1;

    @Out(required = false)
    String info2;

    @Out(required = false)
    String imgSuper;

    @Out(required = false)
    String infoSuper;

    @Out(required = false)
    String imgFinal;

    @Out(required = false)
    String infoFinal;

    @RequestParameter
    Long tbpId;

    @RequestParameter
    Long cmpMode;

    private Boolean compareMode;

    @Begin(join = true, flushMode = FlushModeType.MANUAL)
    public void select() throws Exception {
        this.t = (TaskBusinessProcess) session.get(TaskBusinessProcess.class, tbpId);
        if (t.getUser1Answer() != null) {
            if (t.getUser1Answer().getAnswer() != null) {
                this.image();
            }
        }
        if (t.getUser2Answer() != null) {
            if (t.getUser2Answer().getAnswer() != null) {
                this.image2();
            }
        }
        if (t.getSuperAnswer() != null) {
            if (t.getSuperAnswer().getAnswer() != null) {
                this.imageSuper();
            }
        }
        if (this.isFinalImg()) {
            this.imageFinal();
        }
        compareMode = (cmpMode != null && cmpMode.equals(1L));
        log.info("co jest? "+compareMode+" "+isCompareMode());
    }

    public TaskBusinessProcess getTask() {
        return t;
    }

    public void setTask(TaskBusinessProcess t) {
        this.t = t;
    }

    public Long getTbpId() {
        return tbpId;
    }

    public void setTbpId(Long tbpId) {
        this.tbpId = tbpId;
    }

    public void image() throws Exception {
        SVGImage image;
        image = treeRenderer.renderImage(new TreeXMLParser().parse(t.getUser1Answer().getAnswer()), null, new LinkedList<NonterminalNode>());
        img1 = new String(image.getData());
        info1 = treeRenderer.generateTreeInfo(new TreeXMLParser().parse(t.getUser1Answer().getAnswer()), null, new LinkedList<NonterminalNode>(), true).toString();
    }

    private void image2() throws Exception {
        SVGImage image;
        image = treeRenderer.renderImage(new TreeXMLParser().parse(t.getUser2Answer().getAnswer()), null, new LinkedList<NonterminalNode>());
        img2 = new String(image.getData());
        info2 = treeRenderer.generateTreeInfo(new TreeXMLParser().parse(t.getUser2Answer().getAnswer()), null, new LinkedList<NonterminalNode>(), true).toString();
    }

    private void imageSuper() throws Exception {
        SVGImage image;
        image = treeRenderer.renderImage(new TreeXMLParser().parse(t.getSuperAnswer().getAnswer()), null, new LinkedList<NonterminalNode>());
        imgSuper = new String(image.getData());
        infoSuper = treeRenderer.generateTreeInfo(new TreeXMLParser().parse(t.getSuperAnswer().getAnswer()), null, new LinkedList<NonterminalNode>(), true).toString();
    }

    private void imageFinal() throws Exception {
        SVGImage image;
        if (t.getSuperAnswer() != null) {
            image = treeRenderer.renderImage(new TreeXMLParser().parse(t.getSuperAnswer().getAnswer()), null, new LinkedList<NonterminalNode>());
            infoFinal = treeRenderer.generateTreeInfo(new TreeXMLParser().parse(t.getSuperAnswer().getAnswer()), null, new LinkedList<NonterminalNode>(), true).toString();
        } else {
            image = treeRenderer.renderImage(new TreeXMLParser().parse(t.getUser1Answer().getAnswer()), null, new LinkedList<NonterminalNode>());
            infoFinal = treeRenderer.generateTreeInfo(new TreeXMLParser().parse(t.getUser1Answer().getAnswer()), null, new LinkedList<NonterminalNode>(), true).toString();
        }
        imgFinal = new String(image.getData());
    }

    public String makeInfo(Answer a) throws Exception {
        return treeRenderer.generateTreeInfo(
                new TreeXMLParser().parse(a.getAnswer()),
                null,
                new LinkedList<NonterminalNode>(),
                true).toString();
    }

    public Boolean areComments() {
        if (t.getUser1Answer() != null) {
            if (!t.getUser1Answer().getComment().isEmpty()) {
                return true;
            }
        }
        if (t.getUser2Answer() != null) {
            if (!t.getUser2Answer().getComment().isEmpty()) {
                return true;
            }
        }
        if (t.getSuperAnswer() != null) {
            if (!t.getSuperAnswer().getComment().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public Boolean isFinalImg() {
        if (t.getSuperAnswer() != null && !t.getSuperAnswer().getType().equals(AnswerType.FULL))
            return false; // nie ma drzewa - nie pokazujemy drzewa
        return (t.getState().equals(TaskBusinessProcessState.COLLISION_SOLVED) || t.getState().equals(TaskBusinessProcessState.AUTOACCEPTED));
    }

    public Boolean isFirstImg() {
        if (t.getUser1Answer() != null && !t.getUser1Answer().getType().equals(AnswerType.FULL))
            return false; // nie ma drzewa - nie pokazujemy drzewa
        if (isCompareMode() && user.getUsername().equals(t.getUser1Answer().getUser().getUsername()))
            return true;
        if (this.isFinalImg()) {
            return false;
        } else if (t.getUser1Answer() != null) {
            if (t.getUser1Answer().isAccepted() == true) {
                return true;
            }
        }
        return false;
    }

    public Boolean isSecondImg() {
        if (t.getUser2Answer() != null && !t.getUser2Answer().getType().equals(AnswerType.FULL))
            return false; // nie ma drzewa - nie pokazujemy drzewa
        if (isCompareMode() && user.getUsername().equals(t.getUser2Answer().getUser().getUsername()))
            return true;
        if (this.isFinalImg()) {
            return false;
        } else if (t.getUser2Answer() != null) {
            if (t.getUser1Answer().isAccepted() == true) {
                return true;
            }
        }
        return false;
    }

    public Boolean isSuperImg() {
        return false;
    }

    public Boolean isCompareMode() {
        return compareMode;
    }

    public Answer getAnswer() {
        //assert isCompareMode();
        if (user.getUsername().equals(t.getUser1Answer().getUser().getUsername())) {
            return t.getUser1Answer();
        }
        if (user.getUsername().equals(t.getUser2Answer().getUser().getUsername())) {
            return t.getUser2Answer();
        }
        return null;
    }
}
