/*
 * UserList.java
 *
 * Autor: Karolina Sołtys
 */

package dendrarium.portal.profile;

import dendrarium.core.entities.User;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;

/**
 *
 * @author Karolina Sołtys
 */
@Name("userList")
@Scope(ScopeType.SESSION)
public class UserList implements Serializable {

    @In
    Session session;

    @DataModel
    private List<User> users;

    @Factory("users")
    @Observer("userListChange")
    public void getUsers() {
        this.users = session.createQuery("from User").list();
    }

}
