package dendrarium.portal.stats;

import java.io.Serializable;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author tomek
 */
public class DateChoice implements Serializable {

    public enum Months {

        Styczeń, Luty, Marzec, Kwiecień, Maj,
        Czerwiec, Lipiec, Sierpień, Wrzesień, Październik, Listopad, Grudzień
    }

    private List<Months> choiceMonths; //Miesiące do wyświetlenia

    private List<Integer> choiceYears; //Miesiące do wyświetlenia

    private Months currentMonth;

    private Integer currentYear;

    /**
     * @return the choiceYears
     */
    public List<Integer> getChoiceYears() {
        return choiceYears;
    }

    public DateChoice() {
        Calendar now = Calendar.getInstance();
        currentYear = now.get(Calendar.YEAR);
        currentMonth = Months.values()[now.get(Calendar.MONTH)];
        List<Months> monthsList = new LinkedList<Months>();
        for (Months m : EnumSet.range(Months.Styczeń, Months.Grudzień)) { //poprawka (pta) //currentMonth)) {
            monthsList.add(m);
        }
        choiceMonths = monthsList;
        choiceYears = new LinkedList<Integer>();
        Integer firstYear = 2009; // Kiedyś trzeba będzie dodać namedQuery z pytaniem
        // o rok pierwszej odpowiedzi
        for (int i = firstYear ; i <= now.get(Calendar.YEAR) ; i++) {
            choiceYears.add(i);
        }
    }

    /**
     * @param choiceYears the choiceYears to set
     */
    public void setChoiceYears(List<Integer> choiceYears) {
        this.choiceYears = choiceYears;
    }

    /**
     * @return the currentMonth
     */
    public Months getCurrentMonth() {
        return currentMonth;
    }

    /**
     * @param currentMonth the currentMonth to set
     */
    public void setCurrentMonth(Months currentMonth) {
        this.currentMonth = currentMonth;
    }

    /**
     * @return the currentYear
     */
    public Integer getCurrentYear() {
        return currentYear;
    }

    /**
     * @param currentYear the currentYear to set
     */
    public void setCurrentYear(Integer currentYear) {
        this.currentYear = currentYear;
    }

    /**
     * @return the choiceMonths
     */
    public List<Months> getChoiceMonths() {
        return choiceMonths;
    }

    /**
     * @param choiceMonths the choiceMonths to set
     */
    public void setChoiceMonths(List<Months> choiceMonths) {
        this.choiceMonths = choiceMonths;
    }
}
