/*
 * StatsBean.java
 *
 * Autor: Piotr Achinger <piotr.achinger at gmail.com>
 */
package dendrarium.portal.stats;

import dendrarium.portal.MenuItem;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;

/*
 * @author Piotr Achinger <piotr.achinger at gmail.com> & Tomasz Badowski
 */

@Name("statsFactory")
@Scope(ScopeType.SESSION)
public class StatsFactory implements Serializable {

    @Out(required = false)
    List<MenuItem> statsMenuItems;

    @Logger
    Log log;

    @Factory
    public void getStatsMenuItems() {
        statsMenuItems = new LinkedList<MenuItem>();
        statsMenuItems.add(new MenuItem("dendrolog", "statsDendrolog.seam", true));
        statsMenuItems.add(new MenuItem("superdendrolog", "statsSuperdendrolog.seam", false));
    }
}