package dendrarium.portal.stats;

import dendrarium.core.entities.User;
import dendrarium.portal.MenuItem;
import dendrarium.portal.stats.DateChoice.Months;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Session;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.log.Log;

/**
 *
 * @author Tomasz Badowski
 * przerobiłem trochę, żeby nadawało się też dla gramatyka - janek37
 */
@Name("statsSuperdendrolog")
@Scope(ScopeType.SESSION)
public class StatsSuperdendrolog implements Serializable {

    @Out(required = false)
    List<MenuItem> statsSuperdendrologMenuItems;

    @Logger
    Log log;

    @DataModel
    private List<DendrologStatsData> statsDataList;

    @DataModel
    private List<DendrologStatsData> summaryStatsData;


    @Out(required = false)
    private List<DendrologActivity> dendrActList;

    @Out(required = false)
    private List<DendrologActivity> superActList;

    @In
    private Session session;

    @In
    User user;

    @Out(required = false)
    DateChoice superDateChoice = new DateChoice();

    @In FacesMessages facesMessages;

    @Factory("superDateChoice")
    public DateChoice getSuperDateChoice() {
        return superDateChoice;
    }

    @Out(required = false)
    SuperStatsData superStats;

    @Out(required = false)
    List<Integer> superMonthNums;

    @RequestParameter
    Boolean grmMode;

    @Out(required = false)
    Boolean gramatykMode;

    Months currentMonth;

    public void selectDate() {
        /* Dostosowanie tabelki do nowej daty */
        if (session == null || user == null) {
            facesMessages.add("Brak session lub usera!");
            return;
        }
        getDendrActList();
        getSuperActList();
        getSuperMonthNums();
    }

    //@Factory("statsDataList")
    //@Observer("tbpchangestate")
    public void getStatsDataList() {
        List<User> dendrologs = session.getNamedQuery("getDendrologs").list();
        List<DendrologStatsData> dendrologStats = new LinkedList<DendrologStatsData>();
        for (User u : dendrologs) {
            dendrologStats.add(makeData(u));
        }
        statsDataList = dendrologStats;
        //return statsDataList;
    }

    //@Factory("summaryStatsData")
    //@Observer("tbpchangestate")
    public void getSummaryStatsData() {
        summaryStatsData = new LinkedList<DendrologStatsData>();
        summaryStatsData.add(makeSummaryData());
        //return summaryStatsData;
    }


//    public void makeMonthActList(Calendar cal, DendrologActivity dendrAct) {
//        /*parametr date kalendarza ustawiony na ostatni interesujący nas dzień
//         * miesiąca, parametr year i month na właściwy rok i miesiąc
//         */
//        Calendar cal2 = Calendar.getInstance();
//        cal2.set(Calendar.YEAR, cal.get(Calendar.YEAR));
//        cal2.set(Calendar.MONTH, cal.get(Calendar.MONTH));
//        cal2.set(Calendar.DAY_OF_MONTH, 1);
//        cal2.set(Calendar.HOUR, 0);
//        cal2.set(Calendar.MINUTE, 0);
//        Date startDate;
//        Date finishDate;
//        Long numAns;
//        StatsDendrolog sDendr = new StatsDendrolog();
//        List<Long> monthDoneList = new LinkedList<Long>();
//        for (int i = 1; i <= cal.get(Calendar.DATE) ; i++) {
//            startDate = new Date(cal2.getTimeInMillis());
//            cal2.add(Calendar.DAY_OF_MONTH, 1);
//            finishDate = new Date(cal2.getTimeInMillis());
//            numAns = (Long) session.getNamedQuery("NumAnswersInterval")
//                    .setParameter("user", dendrAct.getUser()).setTimestamp("startDate", startDate)
//                    .setTimestamp("finishDate", finishDate).uniqueResult();
//            monthDoneList.add(numAns);
//        }
//        dendrAct.setMonthDoneList(monthDoneList);
//        superMonthNums = new LinkedList<Integer>();
//        for (Integer i = 1; i <= cal.get(Calendar.DATE); i++) {
//            superMonthNums.add(i);
//        }
//    }

    @Factory("superMonthNums")
//    @Observer("newDate")
    public void getSuperMonthNums() {
        StatsDendrolog sDendr = new StatsDendrolog();
        Calendar cal = sDendr.actCalendar(superDateChoice);
        superMonthNums = sDendr.makeNumsList(cal);
    }


    //@Factory("dendrActList")
    //@Observer("tbpchangestate")
    public List<DendrologActivity> getDendrActList() {
        dendrActList = new LinkedList<DendrologActivity>();
        StatsDendrolog sDendr = new StatsDendrolog();
        Long numAns;
        Calendar cal = sDendr.actCalendar(superDateChoice);
        List<User> dendrologs = session.getNamedQuery("getDendrologs").list();
        for (User u: dendrologs) {
            DendrologActivity dendrAct = new DendrologActivity(u);
            dendrAct.setMonthDoneList(sDendr.makeMonthDoneList(cal, u, session, false));
            dendrActList.add(dendrAct);
        }
        return dendrActList;
    }

    //@Factory("superActList")
    //@Observer("tbpchangestate")
    public List<DendrologActivity> getSuperActList() {
        superActList = new LinkedList<DendrologActivity>();
        StatsDendrolog sDendr = new StatsDendrolog();
        Long numAns;
        Calendar cal = sDendr.actCalendar(superDateChoice);
        List<User> superdendrologs = session.getNamedQuery("getSuperdendrologs").list();
        for (User u: superdendrologs) {
            DendrologActivity dendrAct = new DendrologActivity(u);
            dendrAct.setMonthDoneList(sDendr.makeMonthDoneList(cal, u, session, true));
            superActList.add(dendrAct);
        }
        return superActList;
    }

    //@Factory("superStats")
    //@Observer("tbpchangestate")
    public void getSuperStats() {
        superStats = makeSuperData(user);
        //return superStats;
    }

    public SuperStatsData makeSuperData(User user) {
        SuperStatsData data = new SuperStatsData(user);
        data.setSuperCollisionsNum((Long) session.getNamedQuery("superCollisionsNum").uniqueResult());
        if (grmMode == null || !grmMode)
            data.setSuperSolvedCollisionsNum((Long) session.getNamedQuery("superSolvedCollisionsNum").setParameter("user", user).uniqueResult());
        return data;
    }

    public DendrologStatsData makeData(User user) {
        DendrologStatsData data = new DendrologStatsData(user);
        data.setMyAllAnsNum((Long) session.getNamedQuery("myAllAnsNum1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("myAllAnsNum2").setParameter("user", user).uniqueResult());
        data.setMyAllDoneAnsNum((Long) session.getNamedQuery("myAllDoneAnsNum1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("myAllDoneAnsNum2").setParameter("user", user).uniqueResult());
        data.setMyAllNeedConfNum((Long) session.getNamedQuery("myNeedConfNum1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("myNeedConfNum2").setParameter("user", user).uniqueResult());
        data.setMyFullNum((Long) session.getNamedQuery("myFullNum1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("myFullNum2").setParameter("user", user).uniqueResult());
        data.setMySpecialNum((Long) session.getNamedQuery("mySpecialNum1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("mySpecialNum2").setParameter("user", user).uniqueResult());
        data.setMyNotAccepted((Long) session.getNamedQuery("myNotAccepted1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("myNotAccepted2").setParameter("user", user).uniqueResult());
        data.setMyAgreements((Long) session.getNamedQuery("myAgreements1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("myAgreements2").setParameter("user", user).uniqueResult());
        data.setMyNoTree((Long) session.getNamedQuery("myNoTree1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("myNoTree2").setParameter("user", user).uniqueResult());
        data.setMyRejected((Long) session.getNamedQuery("myRejected1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("myRejected2").setParameter("user", user).uniqueResult());
        data.setMySolved((Long) session.getNamedQuery("mySolved1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("mySolved2").setParameter("user", user).uniqueResult());
        data.setMyRight((Long) session.getNamedQuery("myRight1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("myRight2").setParameter("user", user).uniqueResult());
        //System.out.println((session.getNamedQuery("myNieprzydzielone2").setParameter("user", user).uniqueResult()));
        data.setNieprzydzielone((Long) (session.getNamedQuery("myNieprzydzielone1").uniqueResult())  + (Long) (session.getNamedQuery("myNieprzydzielone2").setParameter("user", user).uniqueResult()));
        /*
        data.onlyMineNum = (Long) session.getNamedQuery("onlyMineDoneNum")
        .setParameter("user", user).uniqueResult();
        data.myAcceptedNum = (Long) session.getNamedQuery("myAcceptedNum")
        .setParameter("user", user).uniqueResult();
         */
        data.setMyCollisionsNum((Long) session.getNamedQuery("myCollisionsNum1").setParameter("user", user).uniqueResult() + (Long) session.getNamedQuery("myCollisionsNum2").setParameter("user", user).uniqueResult());
        /*Calendar cal = Calendar.getInstance();
        Date startDate, finishDate;
        finishDate = cal.getTime();*/
        //cal.set( year, month + 1, 1 );
        return data;
    }

    public DendrologStatsData makeSummaryData() {
        User u = new User("Liczba zadań", "Liczba","Liczba");
        DendrologStatsData data = new DendrologStatsData(u);
        data.setMyAllAnsNum((Long) session.getNamedQuery("allAnsNum1").uniqueResult() + (Long) session.getNamedQuery("allAnsNum2").uniqueResult());
        data.setMyAllDoneAnsNum((Long) session.getNamedQuery("allDoneAnsNum1").uniqueResult() + (Long) session.getNamedQuery("allDoneAnsNum2").uniqueResult());
        data.setMyAllNeedConfNum((Long) session.getNamedQuery("allNeedConfNum1").uniqueResult() + (Long) session.getNamedQuery("allNeedConfNum2").uniqueResult());
        data.setMyFullNum((Long) session.getNamedQuery("fullNum1").uniqueResult() + (Long) session.getNamedQuery("fullNum2").uniqueResult());
        data.setMySpecialNum((Long) session.getNamedQuery("specialNum1").uniqueResult() + (Long) session.getNamedQuery("specialNum2").uniqueResult());
        data.setNieprzydzielone((Long) session.getNamedQuery("nieprzydzielone1").uniqueResult() + (Long) session.getNamedQuery("nieprzydzielone2").uniqueResult());
        data.setMyNotAccepted((Long) session.getNamedQuery("notAccepted1").uniqueResult() + (Long) session.getNamedQuery("notAccepted2").uniqueResult());
        data.setMyAgreements((Long) session.getNamedQuery("agreements1").uniqueResult() + (Long) session.getNamedQuery("agreements2").uniqueResult());
        data.setMyNoTree((Long) session.getNamedQuery("noTree1").uniqueResult() + (Long) session.getNamedQuery("noTree2").uniqueResult());
        data.setMyRejected((Long) session.getNamedQuery("rejected1").uniqueResult() + (Long) session.getNamedQuery("rejected2").uniqueResult());
        data.setMySolved((Long) session.getNamedQuery("solved1").uniqueResult() + (Long) session.getNamedQuery("solved2").uniqueResult());
        data.setMyRight((Long) session.getNamedQuery("right1").uniqueResult() + (Long) session.getNamedQuery("right2").uniqueResult());
        /*
        data.onlyMineNum = (Long) session.getNamedQuery("onlyMineDoneNum")
        .setParameter("user", user).uniqueResult();
        data.myAcceptedNum = (Long) session.getNamedQuery("myAcceptedNum")
        .setParameter("user", user).uniqueResult();
         */
        //data.setMyCollisionsNum(2*((Long) session.getNamedQuery("collisionsNum").uniqueResult()));
        data.setMyCollisionsNum((Long) session.getNamedQuery("collisionsNum1").uniqueResult() + (Long) session.getNamedQuery("collisionsNum2").uniqueResult());
        return data;
    }


    @Factory
    public void getStatsSuperdendrologMenuItems() {
        statsSuperdendrologMenuItems = new LinkedList<MenuItem>();
        statsSuperdendrologMenuItems.add(new MenuItem("dendrolog", "statsDendrolog.seam", false));
        statsSuperdendrologMenuItems.add(new MenuItem((grmMode != null && grmMode)? "gramatyk" : "superdendrolog", "statsSuperdendrolog.seam", true));
    }

    @Factory //?
    public void getGramatykMode() {
        gramatykMode = grmMode;
    }

    public void prepareData() {
        getStatsDataList();
        getSummaryStatsData();
        getSuperStats();
    }
}