/*
 * AnswerData.java
 *
 * Autor: Piotr Achinger <piotr.achinger at gmail.com>
 */
package dendrarium.trees;

import dendrarium.core.entities.Answer;

/**
 *
 * @author Piotr Achinger <piotr.achinger at gmail.com>
 */
public class AnswerData {

    private String username;

    private AnswerType type;


    private String comment;

    public AnswerData(Answer answer) {
        this.username = answer.getUser() == null ? "none" : answer.getUser().getUsername();
        this.type = answer.getType();
        this.comment = answer.getComment();
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public AnswerType getType() {
        return type;
    }

    public void setType(AnswerType type) {
        this.type = type;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public AnswerData() {
    }

    public AnswerData(String username, AnswerType type, String comment) {
        this.username = username;
        this.type = type;
        this.comment = comment;
    }
}
