/*
 * AnswerType.java
 *
 * Autor: Karolina Sołtys <ksoltys at gmail.com>
 */
package dendrarium.trees;

import java.io.Serializable;
import java.util.EnumSet;

/**
 * Typy odpowiedzi (pelna i specjalne).
 *
 * Odpowiedz wie, czy jest wlasciwa zdaniom bez drzew oraz
 * czy wymaga komentarza, zna tez swoj slowny opis.
 *
 * Cytat z maila MW "lista odpowiedzi specjalnych", 12 grudnia 2009:
 *
 * przesyłam skonsultowaną ze współpracownikami ostateczną listę odpowiedzi
 * specjalnych.  Lista jest ta sama, niezależnie czy są drzewa, czy nie ma:
 *
 * **** błąd w opisie morfologicznym lub segmentacji
 * **** brak poprawnego drzewa
 * **** zdanie poprawne, ale zbyt trudne do opisania
 * **** wypowiedzenie poprawne, ale nie zdanie
 * **** wypowiedzenie niepoprawne
 *
 * Każda odpowiedź specjalna wymaga komentarza, z wyjątkiem sytuacji, gdy
 * nie ma drzew, a dendrolog wybiera „brak poprawnego drzewa”.  Wtedy
 * komentarz jest opcjonalny.
 *
 *
 * Cytat z maila MW "rozwoj Dendrarium", 13 listopada 2009:
 * 
 * *** jakie odpowiedzi przy braku drzew?
 *    inne niż przy obecności drzew!  te odpowiedzi z założenia nie
 *    zachowują się przy MUZGowaniu: jeżeli będzie wprowadzona nowa
 *    wersja takiego zdania (mająca jakiekolwiek drzewa), to zdanie
 *    automatycznie wraca do ponownych oględzin.
 *    Lista (wymyślę krótsze napisy):
 * **** zdanie poprawne podlegające opisowi — wina parsera
 * **** TODO zdanie poprawne, ale zbyt trudne do opisania
 *     (nieciągłości, oratio recta, fragmenty w nawiasach? …)
 *     [musimy przygotować listę legalnych powodów odrzucania!]
 * **** wypowiedzenie poprawne, ale nie zdanie
 * **** wypowiedzenie niepoprawne
 * 
 * *** jeżeli nie ma drzew, to odpowiedź „poprawne — wina parsera” nie
 *     wymaga komentarza
 *     pozostałe wymagają niepustego komentarza
 * 
 * *** w wypadku gdy są drzewa, zestaw odpowiedzi specjalnych ma być taki:
 *    (w szczególności rezygnujemy z odpowiedzi o „braku ramki
 * walencyjnej”)
 * **** błąd w opisie morfologicznym lub segmentacji
 * **** brak poprawnego drzewa
 * **** zdanie poprawne, ale zbyt trudne do opisania
 * **** wypowiedzenie poprawne, ale nie zdanie
 * **** wypowiedzenie niepoprawne
 * **** inne
 *
 *
 * @author Piotr Achinger <piotr.achinger at gmail.com>
 */
public enum AnswerType implements Serializable {

    FULL("Pełna odpowiedź.", false), //0
    MORPH("Błąd w opisie morfologicznym lub segmentacji."), //1
    NO_TREE("Brak poprawnego drzewa."), //2
    TOO_DIFFICULT("Zdanie poprawne, ale zbyt trudne do opisania."), //3
    NOT_SENTENCE("Wypowiedzenie poprawne, ale nie zdanie."), //4
    WRONG_SENTENCE("Wypowiedzenie niepoprawne"); //5

    private String name;

    private boolean commentRequired = true;

    public String getName() {
        return name;
    }

    public boolean isCommentRequired() {
        return commentRequired;
    }

    private AnswerType(String value) {
        this.name = value;
    }

    private AnswerType(String name, boolean commentRequired) {
        this.name = name;
        this.commentRequired = commentRequired;
    }

    public static final EnumSet<AnswerType> SENTENCE_ERRORS = EnumSet.of(NOT_SENTENCE, TOO_DIFFICULT, WRONG_SENTENCE);
}
