package dendrarium.trees;

import java.util.Map;

/**
 *
 * @author pta
 */
public class TerminalNode extends Node {

    /**
     * Atrybut token_id elementu node w XML
     */
    private String token_id = "";

    /**
     * Atrybut interp_id elementu node w XML
     */
    private String interp_id = "";

    /**
     * Atrybut nps elementu node w XML.
     *
     * Mowi, czy PRZED danym terminalem ma nastapic spacja.
     */
    private boolean nps = false;

    /**
     * Atrybut disamb elementu node w XML.
     *
     * Mowi, czy dany terminal ma poprawna wg. NKJP interpretacje
     * morfosyntaktyczna.
     */
    private boolean disamb = false;

    private String orth;

    private String base;

    public TerminalNode(int id,
            int from, int to, long subtrees,
            String orth, String base) {
        super(id, from, to, subtrees);
        this.orth = orth;
        this.base = base;
    }

    public boolean isEquivalentTo(Node otherNode) {
        if (!(otherNode instanceof TerminalNode)) {
            return false;
        } else {
            TerminalNode other = (TerminalNode) otherNode;

            return orth.equals(other.orth) && base.equals(other.base) && to == other.to && from == other.from; // TODO: spytac MW o zasieg
        }
    }

    public boolean isLeaf() {
        return true;
    }

    /**
     * Tekstowa reprezentacja danego terminala.
     *
     * Terminale sa przejsciami w grafie terminali (TerminalGraph).
     * W momencie gdy chcemy z fragmentu zdania (np. wszystkiego, co wisi
     * pod danym wezlem) zrobic tekst, konkatenujemy wartosci getText()
     * dla wszystkich wezlow-przejsc na najkrotszej sciezcie pomiedzy
     * to a from w grafie terminali.
     *
     * Bierzemy pod uwage atrybut nps ktory mowi, czy przed terminalem
     * nastepuje spacja.
     *
     * Slowo o ktore chodzi jest pierwszym wymienionym atrybutem etykiety, np.
     * terminal(morf(Kolej, kolej, subst:sg:[nom|acc]:f)) -> "Kolej"
     */
    public String getText() {
        return (nps ? "" : " ") + orth;
    }

    public String getSymbol() {
        return orth;
    }

    public String getLabel() {
        return "terminal(" + orth + ", " + base + ", " + getAttribute("tag") + ")";
    }

    /**
     * Czy wezel jest terminalem zgodnym z analiza morfosyntaktyczna NKJP
     * lub posiada wybor zestawu dzieci zgodny z ta analiza.
     *
     * Formalnie:
     *    f(node) = true jesli node jest terminalem
     *    f(node) = true jesli f(children) = true dla PEWNEGO wariantu children
     *                         danego wezla
     *    f(children) = true jesli f(node) = true dla KAZDEGO wezla danego
     *                             wariantu
     */
    public boolean hasNKJPCompliantVariant() {
        return disamb;
    }

    /* === G & S === */
    public String getInterp_id() {
        return interp_id;
    }

    public void setInterp_id(String interp_id) {
        this.interp_id = interp_id;
    }

    public String getToken_id() {
        return token_id;
    }

    public void setToken_id(String token_id) {
        this.token_id = token_id;
    }

    public boolean isDisamb() {
        return disamb;
    }

    public void setDisamb(boolean disamb) {
        this.disamb = disamb;
    }

    public boolean isNps() {
        return nps;
    }

    public void setNps(boolean nps) {
        this.nps = nps;
    }

    public String getBase() {
        return base;
    }

    public String getOrth() {
        return orth;
    }


}
