package dendrarium.trees.disamb;

import dendrarium.utils.Pair;
import java.io.Serializable;
import java.util.List;

/**
 *
 * @author Tomasz Badowski
 */
public class ChildInfo implements Serializable {

    private String label;

    private List<Pair<String, String>> attr;

    private List<String> diffAttr;

    private List<String> subSentence;

    /**
     * @return the label
     */
    public String getLabel() {
        return label;
    }

    /**
     * @param label the label to set
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * @return the attr
     */
    public List<Pair<String, String>> getAttr() {
        return attr;
    }

    /**
     * @param attr the attr to set
     */
    public void setAttr(List<Pair<String, String>> attr) {
        this.attr = attr;
    }

    public String getAttrString() {
        if (attr.isEmpty()) {
            return "";
        }

        StringBuilder sb = new StringBuilder();

        for (Pair<String, String> p : attr) {
            sb.append(p.getF2() + ", ");
        }

        String s = sb.toString();
        return s.substring(0, s.length() - 2);
    }

    /**
     * @return the diffAttr
     */
    public List<String> getDiffAttr() {
        return diffAttr;
    }

    /**
     * @param diffAttr the diffAttr to set
     */
    public void setDiffAttr(List<String> diffAttr) {
        this.diffAttr = diffAttr;
    }

    public List<String> getSubSentence() {
        return subSentence;
    }

    public void setSubSentence(List<String> subSentence) {
        this.subSentence = subSentence;
    }

    public ChildInfo(String label, List<Pair<String, String>> attr, List<String> diffAttr,
            List<String> subSentence) {
        this.label = label;
        this.attr = attr;
        this.diffAttr = diffAttr;
        this.subSentence = subSentence;
    }
}
