package dendrarium.trees.disamb;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.jboss.seam.log.Log;


/**
 *
 * @author axw
 */
public class ConstituentsSequenceComparator implements Comparator<Variant> {
    public Log log;
    
    public ConstituentsSequenceComparator() {
    }

    /**
     * Get indices of the boundaries of constituents.
     * @param v  Variant to analyse
     * @return A  list of Ingerers; for each constituent the index where it
     *   starts is added to the list.
     */
    private static List<Integer> getConstituents(Variant v) {
        int index = 0;
        List<Integer> ret = new ArrayList<Integer>();
        for (ChildInfo c: v.getChildren()) {
            ret.add(index);
            index += c.getSubSentence().size();
        }
        return ret;
    }
    
    @Override
    public int compare(Variant v1, Variant v2) {
        List<Integer> c1 = getConstituents(v1);
        List<Integer> c2 = getConstituents(v2);

        int l = c1.size() < c2.size() ? c2.size() : c1.size();
        for (int i = 0; i < l; i++) {
            int value1 = i >= c1.size() ? 10000 : c1.get(i);
            int value2 = i >= c2.size() ? 10000 : c2.get(i);

            if (value2 < value1) return -1;
            if (value2 > value1) return 1;
        }

        return 0;
    }
}
