/*
 * DifferenceList.java
 *
 * Autor: Dominika Pawlik <dominika.pawlik at gmail.com>
 */
package dendrarium.trees.disamb;

import dendrarium.trees.*;
import java.util.List;
import java.util.Vector;

/**
 *
 * @author Dominika Pawlik <dominika.pawlik at gmail.com>
 */
public class DifferenceList {

    private Vector<Integer> differenceList = null;

    private boolean symbolDiffers = false;

    private Node descendant = null;

    private boolean hasDescendant = false;

    public DifferenceList(Node node) {
        this.init(node);
    }

    private void init(Node node) {
        differenceList = new Vector<Integer>();
        symbolDiffers = false;
        descendant = null;
        hasDescendant = false;
    }

    public List<Integer> getIndexes() {
        return differenceList;
    }

    public void addIndex(int position) {
        differenceList.add(position);
    }

    public void symbolDiffers() {
        symbolDiffers = true;
    }

    public boolean getSymbolDiffers() {
        return symbolDiffers;
    }

    public void setDescendant(Node node) {
        descendant = node;
        hasDescendant = true;
    }

    public Node getDescendant() {
        return descendant;
    }

    public boolean hasDescendant() {
        return hasDescendant;
    }
}
