package dendrarium.trees.disamb;

import dendrarium.trees.Forest;
import dendrarium.trees.Node;
import dendrarium.trees.NodeChildren;
import dendrarium.trees.NonterminalNode;

/**
 *
 * @author ks
 */
public class MUZGDisambiguator extends NKJPDisambiguator {

    private Disambiguator newAnswerDisambiguator;

    public MUZGDisambiguator(Forest oldForest, Disambiguator newAnswerDisambiguator) {
        super(oldForest);
        this.newAnswerDisambiguator = newAnswerDisambiguator;
    }

    /** Dezambiguator MUZGu działa (wykonuje saturate) na starej odpowiedzi;
     * jednocześnie próbuje wybrać stare warianty dezambiguatorem (Quiet) nowej
     * odpowiedzi. Dla każdego wierzchołka, który w starej odpowiedzi ma wybrane
     * dziecko, szukamy równoważnego wierzchołka w nowym lesie - jeśli znajdziemy
     * takie wierzchołki, to dla każdego z nich szukamy dzieci, równoważnych dziecku
     * wybranemu w starej odpowiedzi.
     * Równoważność sprawdzają metody isEquivalentTo w Node i w NodeChildren.
     */
    @Override
    public void chooseAuto(int nodeId, int childrenNo) {
        NonterminalNode node = (NonterminalNode) forest.nodeById(nodeId);
        NodeChildren children = node.getChildren().get(childrenNo);

        for (Node newNode : newAnswerDisambiguator.getForest().getNodeList()) {
            if (newNode instanceof NonterminalNode) {
                NonterminalNode nt = (NonterminalNode) newNode;

            if (nt.isEquivalentTo(node)) {
                for (int newChildrenNo = 0; newChildrenNo < nt.getChildren().size(); newChildrenNo++) {
                    if (nt.getChildren().get(newChildrenNo).isEquivalentTo(children)) {
                        nt.setChoiceType(node.getChoiceType());
                        newAnswerDisambiguator.chooseAuto(nt.getId(), newChildrenNo);
                    }
                }
            }
            }
        }
        super.chooseAuto(nodeId, childrenNo);
    }

    @Override
    public void setCurrent(NonterminalNode node) {
    }

}
