package dendrarium.trees.disamb;

import dendrarium.trees.Forest;
import dendrarium.trees.NonterminalNode;

/** dezambiguator NKJP wspomaga się przy automatycznym wybieraniu wierzchołków
 * faktem zgodności z NKJP - szczegóły w metodzie saturate Disambiguatora)
 * @author ks
 */
public class NKJPDisambiguator extends Disambiguator {

    public NKJPDisambiguator(Forest forest) {
        super(forest);
    }

    /** dany wariant jest sugerowany, jeśli jest zgodny z NKJP */
    @Override
    public boolean isSuggested(int nodeId, int childrenNo) {
        NonterminalNode parent = (NonterminalNode) forest.nodeById(nodeId);
        return parent.getChildren().get(childrenNo).hasNKJPCompliantNodes() || super.isSuggested(nodeId, childrenNo);
    }

    /** warianty niezgodne z NKJP oznaczamy napisem, który będzie widoczny w interfejsie */
    @Override
    public String decorate(int nodeId, int childrenNo) {
        String ret = "";
        NonterminalNode parent = (NonterminalNode) forest.nodeById(nodeId);
        if (!parent.getChildren().get(childrenNo).hasNKJPCompliantNodes()) {
            ret += "::Niezgodne z NKJP::    ";
        }
        return ret + super.decorate(nodeId, childrenNo);
    }
}
